/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Args.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\Args.h>



Args::Args()
{
	max = 50;
	num = 0;
	arg = new Arg[max];
}


Args& Args::reset()
{
	num = 0;
	return *this;
}


Args::~Args()
{
	delete [] arg;
}


Args& Args::put(const char* name, ulong value)
{
	for(int i = 0; i<num; i++) {
		if(arg[i].name == name) {
			XtSetArg(arg[i], name, value);
			return *this;
		}
	}
	XtSetArg(arg[num], name, value);
	if(num < max) num++;
	return *this;
}


Args& Args::set(const char* name, ulong value)
{
	ulong val = value;

	for(int i = 0; i<num; i++) {
		if(arg[i].name == XmNstyle && 
		   name == XmNstyle) {
			arg[i].value |= val;
			return *this;
		}
		if(arg[i].name == XmNexStyle && 
		   name == XmNexStyle) {
			arg[i].value |= val;
			return *this;
		}
	}
	XtSetArg(arg[num], name, val);

	if(num < max) num++;
	return *this;
}

Args& Args::set(const char* name, int value)
{
	return Args::set(name, (ulong)value);
}

Args& Args::set(const char* name, void* value)
{
	return Args::set(name, (ulong)value);
}

Args& Args::set(const char* name, uint value)
{
	return Args::set(name, (ulong)value);
}


Args& Args::set(const char* name, const char* value)
{
	return Args::set(name, (ulong)value);
}


Args& Args::set(Arg* ar, int num)
{
	ulong val;
	for(int i = 0; i<num; i++) {
		if(get(ar[i].name, &val)) {
			if(val) set(XmNstyle, ar[i].value);
		}
	}
	return *this;
}


ulong Args::get(const char* name)
{
	for(int i = 0; i<num; i++) {
		if(arg[i].name == name) 
			return arg[i].value;
	}
	return 0L;
}


Boolean Args::get(const char* name, ulong* val)
{
	*val = NULL;
	for(int i = 0; i<num; i++) {
		if(arg[i].name == name) {
			*val = arg[i].value;
			return TRUE;
		}
	}
	return FALSE;
}


Args& Args::toPixelUnit()
{
	long unit = GetDialogBaseUnits();
	put(XmNx,     get(XmNx)     *LOWORD(unit)/4);
	put(XmNy,     get(XmNy)     *HIWORD(unit)/8);
	put(XmNwidth, get(XmNwidth) *LOWORD(unit)/4);
	put(XmNheight,get(XmNheight)*HIWORD(unit)/8);
	return *this;
}

