/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	BinaryNode.h
 *
 *****************************************************************************/

// SOL++2000

#ifndef _SOL_OBJECT
#include <sol\Object.h>
#endif

#ifndef _SOL_BINARYNODE
#define _SOL_BINARYNODE

class BinaryNode :public Object {
	float	x;
	float	y;
	char*	name;
	Object* object;
	BinaryNode*	parent;
	BinaryNode*	left;
	BinaryNode*	right;

  public:
	BinaryNode(BinaryNode* parent = null, const char* name = null, 
			Object* object = null);
	BinaryNode(BinaryNode* parent, const char*  name, BinaryNode* left,
			BinaryNode* right);

	~BinaryNode();

	int  		configure(int x, int y);
	
	char* 		getName() { return name; }
	Object*		getObject() { return object; }

	BinaryNode*	getParent() { return parent; }
	BinaryNode*	getLeft() { return left; }
	BinaryNode* getRight() { return right; }
	float		getX() { return x; }
	float		getY() { return y; }
	float 		reconfigure();
	void		print();
	BinaryNode* search(const char* name);
	BinaryNode*	search(int nid);
	void		setName(const char* name1);
	void		setObject(Object* obj) { object = obj; }
	void	setParent(BinaryNode* parent1) { parent = parent1; }
	void 	setLeft(BinaryNode* node) { left = node; }
	void	setRight(BinaryNode* node) { right = node; }

};

#endif

