/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ByteArray.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\ByteArray.h>


ByteArray::ByteArray(UINT size)
	:Array(size)
{
	array    = new char[size];
}


ByteArray::~ByteArray() 
{
	clear();
}

void ByteArray::clear() 
{
	if(array) {
		delete [] array;
	}
	setSize(0);
	array = NULL;
}


void ByteArray::copy(UINT pos, const char* string, UINT len) 
{
	UINT size = getSize();
	if((pos + len) <= size) {
		char* ptr = (array + pos);
		for(UINT i = 0; i<len; i++) 
			*ptr++ = *string++;
	}
}


BOOL ByteArray::expand(UINT len) 
{
	UINT size = getSize();
	BOOL rc = FALSE;
	char* temp = new char[size+len];
	if(temp) {
		for(UINT i = 0; i<size; i++) {
			*(temp + i) = *(array + i);
		}
		size += len;
		setSize(size);
		delete [] array;
		array = temp;
		rc = TRUE;
	}
	return rc;
}


char ByteArray::getNth(UINT pos) 
{
	char val = NULL;
	if(pos < getSize()) {
		val = array[pos];
	}
	return val;
}

