/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	DIBitmap.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\DIBitmap.h>
#include <sol\stdio.h>


DIBitmap::DIBitmap(const char* name, HDIB hdib, int w, int h, 
				   int ncolors)
	:GdiObject(name, hdib)
{
	sx = sy = 0;

	width     = w;
	height    = h;
  	colors    = ncolors; 
	createPalette(hdib);
}


DIBitmap::~DIBitmap()
{
	if(palette) delete palette;
	HDIB hdib = (HDIB)get();
	::GlobalUnlock(hdib);
	::GlobalFree(hdib);
}


BOOL DIBitmap::createPalette(HDIB hdib)
{
	LPBITMAPINFO lpbmi = (LPBITMAPINFO)::GlobalLock(hdib);

   if (colors >0) {
		HANDLE hLogPal = ::GlobalAlloc(GHND, 
					sizeof(LOGPALETTE) + sizeof(PALETTEENTRY)*colors);

		if (hLogPal == 0) {
			::GlobalUnlock(hdib);
			return FALSE;
		}

		LPLOGPALETTE pal = (LPLOGPALETTE)::GlobalLock(hLogPal);

		pal->palVersion = 0x300;
		pal->palNumEntries = (WORD)colors;
	
		for (int i = 0; i < (int)colors; i++) {
			
/*
			Printf("red  [%3d] = %3d;\r\n", i, lpbmi->bmiColors[i].rgbRed);
			Printf("green[%3d] = %3d;\r\n", i, lpbmi->bmiColors[i].rgbGreen);
			Printf("blue [%3d] = %3d;\r\n", i, lpbmi->bmiColors[i].rgbBlue);
			Printf("\t{%3d, %3d, %3d},	// %3d\r\n",
				lpbmi->bmiColors[i].rgbRed,
				lpbmi->bmiColors[i].rgbGreen,
				lpbmi->bmiColors[i].rgbBlue,
				i
				);
*/
			pal->palPalEntry[i].peRed = lpbmi->bmiColors[i].rgbRed;
			pal->palPalEntry[i].peGreen = lpbmi->bmiColors[i].rgbGreen;
			pal->palPalEntry[i].peBlue = lpbmi->bmiColors[i].rgbBlue;
			pal->palPalEntry[i].peFlags = 0;
		}		
		palette = new Palette(pal);
		::GlobalUnlock(hLogPal);
		::GlobalFree(hLogPal);
	}
	::GlobalUnlock(hdib);

	return TRUE;
}

void DIBitmap::setSource(int x, int y)
{
	sx = x;
	sy = y;
}

void DIBitmap::draw(HDC hdc, int x, int y)
{
	HDIB    hdib    = (HDIB)get();
	if(hdib) {	
		LPSTR header = (LPSTR)::GlobalLock(hdib);
		LPBITMAPINFOHEADER lpbmi = (LPBITMAPINFOHEADER)header;

		LPSTR bits= header + lpbmi->biSize +
				colors* sizeof(RGBQUAD);

		HPALETTE pal = ::SelectPalette(hdc, 
						(HPALETTE)palette->get(), TRUE);			
		::RealizePalette(hdc);


		int width  = lpbmi->biWidth;
	   	int height = lpbmi->biHeight;
	
		::SetDIBitsToDevice(hdc,         
						x,             
						y,             
						width, 
						height,
						sx, 
						0, 
						sy, // 0,              
						height,
						bits,   
						(LPBITMAPINFO)header,  
						DIB_RGB_COLORS);
		::SelectPalette(hdc, pal, FALSE);
	}
}


void DIBitmap::draw(DC& dc, int x, int y)
{
	DIBitmap::draw(dc.get(), x, y);

}
