/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	FileDialog.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.01.09 Modified getValues method.

#include <direct.h>
#include <sol\Application.h>
#include <sol\FileDialog.h>

int FileDialog::OPEN = 0;
int FileDialog::SAVE = 1;

FileDialog::FileDialog(View* parent, const char* caption, Args& args)
	:CommonDialog(parent, new OPENFILENAME)
{
	directory    = new char[_MAX_PATH];
	filename     = new char[_MAX_PATH];
	fileTitle    = new char[_MAX_PATH];
	filename[0]  = Zero;
	fileTitle[0] = Zero;
	directory[0] = Zero;

	OPENFILENAME* ofn = get();
	memset(ofn, 0, sizeof(OPENFILENAME));
	getcwd(directory, _MAX_PATH);

	ofn -> lpstrInitialDir= directory; 
	ofn -> lStructSize    = sizeof(OPENFILENAME);
	ofn -> lpstrFilter    = "All files (*.*) \0 *.*\0";
	ofn -> nFilterIndex   = 1;
	ofn -> lpstrFile      = filename;
	ofn -> nMaxFile       = _MAX_PATH;
	ofn -> lpstrFileTitle = fileTitle;
	ofn -> nMaxFileTitle  = _MAX_PATH;
	ofn -> lpstrTitle     = caption;
	ofn -> lpstrDefExt    = (char*)args.get(XmNextension);
	if(parent) {
		ofn -> hwndOwner  = parent -> getWindow();
	}
	ofn -> hInstance      = Application::getInstance();

	flags = NULL;

	// FileOpen in default.
	accessMode = OPEN;

	setValues(args);
}



FileDialog::~FileDialog() 
{
	OPENFILENAME* ofn = get();

	delete [] directory;
	delete [] filename;
	delete [] fileTitle;
	delete ofn;
}


Boolean FileDialog::create(View* parent, const char* caption, Args& args)
{
	Boolean rc = CommonDialog::create(parent, new OPENFILENAME);

	directory    = new char[_MAX_PATH];
	filename     = new char[_MAX_PATH];
	fileTitle    = new char[_MAX_PATH];
	filename[0]  = Zero;
	fileTitle[0] = Zero;
	directory[0] = Zero;

	OPENFILENAME* ofn = get();
	memset(ofn, 0, sizeof(OPENFILENAME));
	getcwd(directory, _MAX_PATH);

	ofn -> lpstrInitialDir= directory; 
	ofn -> lStructSize    = sizeof(OPENFILENAME);
	ofn -> lpstrFilter    = "All files (*.*) \0 *.*\0";
	ofn -> nFilterIndex   = 1;
	ofn -> lpstrFile      = filename;
	ofn -> nMaxFile       = _MAX_PATH;
	ofn -> lpstrFileTitle = fileTitle;
	ofn -> nMaxFileTitle  = _MAX_PATH;
	ofn -> lpstrTitle     = caption;
	ofn -> lpstrDefExt    = (char*)args.get(XmNextension);
	if(parent) {
		ofn -> hwndOwner  = parent -> getWindow();
	}
	ofn -> hInstance      = Application::getInstance();

	flags = NULL;

	// FileOpen in default.
	accessMode = OPEN;

	setValues(args);
	return rc;
}

LPARAM  FileDialog::getCustomData()
{
	OPENFILENAME* ofn = get();
	return ofn -> lCustData;
}


int FileDialog::open()
{
	filename[0]  = NULL;
	fileTitle[0] = NULL;
	setSelf();
	OPENFILENAME* ofn = get();
	ofn -> Flags = flags|OFN_PATHMUSTEXIST|OFN_FILEMUSTEXIST;
	return ::GetOpenFileName(ofn);
}


int FileDialog::save()
{
	filename[0]  = NULL;
	fileTitle[0] = NULL;
	setSelf();
	OPENFILENAME* ofn = get();
	ofn -> Flags = flags|OFN_OVERWRITEPROMPT;
	return ::GetSaveFileName(ofn);
}


void FileDialog::getValues(Args& args)
{
	OPENFILENAME* ofn = get();
	ulong* val = NULL;
	int num   = args.getCount();
	Arg* arg  = args.getArgList();

	for(int i = 0; i<num; i++) {
		const char* name = arg[i].name;
		//<modified date="2000.01.09">
		val = (ulong*)arg[i].value;
		//</modified>

		if (name == XmNflags) {
			*val = (ulong)flags;
			continue;
		}
		if (name == XmNdirectory) {
			*val = (ulong)directory;
			continue;
		}
		if (name == XmNfilter) {
			*val = (ulong)ofn -> lpstrFilter;
			continue;
		}
		if (name == XmNfileName) {
			*val = (ulong)filename;
			continue;
		}
		if (name == XmNfileTitle) {
			*val = (ulong)fileTitle;
			continue;
		}
	}
}


void FileDialog::setValues(Args& args)
{
	OPENFILENAME* ofn = get();

	ulong val;
	if (args.get(XmNaccessMode, &val)) {
		accessMode = (int)val;
	}

	if (args.get(XmNflags, &val)) {
		flags = (DWORD)val;
	}
	if (args.get(XmNhook, &val)) {
		flags |= OFN_ENABLEHOOK;
		if(ofn -> lpfnHook) {
			FreeProcInstance((FARPROC)ofn -> lpfnHook);
		}
		ofn -> lpfnHook = (HOOKFUN)MakeProcInstance((FARPROC)val,
					ofn -> hInstance);
	}
	if (args.get(XmNfileName, &val)) {
		strcpy(filename, (char*)val);
	}
	if (args.get(XmNdirectory, &val)) {
		strcpy(directory, (char*)val);
	}
	if (args.get(XmNfilter, &val)) {
		ofn -> lpstrFilter = (char*)val;
	}
	if (args.get(XmNfilterIndex, &val)) {
		ofn -> nFilterIndex = (int)val;
	}

	if (args.get(XmNdialogTitle, &val)) {
		ofn -> lpstrTitle  = (char*)val;
	}
	if (args.get(XmNtemplateName, &val)) {
		flags |= OFN_ENABLETEMPLATE;
		ofn -> lpTemplateName  = (char*)val;
	}
}


// Modal
void FileDialog::popup(Action& action)
{
	int result = NULL;
	if(accessMode == SAVE) {
		result = save();
	}
	else {
		result = open();
	}
	
	action.setResult(result);
}


void FileDialog::setCaption(const char* caption)
{
	OPENFILENAME* ofn = get();
	ofn -> lpstrTitle = (char*)caption;
}

