/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	FlowLayout.h
 *
 *****************************************************************************/

// SOL++2000


#ifndef _SOL_LAYOUTMANAGER
#include <sol\LayoutManager.h>
#endif

#ifndef _SOL_LINKEDLIST
#include <sol\LinkedList.h>
#endif

#ifndef _SOL_FLOWLAYOUT
#define _SOL_FLOWLAYOUT

class View;
//class Panel;

class FlowLayout :public LayoutManager {
	LinkedList list;
	int		direction;
	int		vgap;
	int		hgap;
	int		vspacing;
	int		hspacing;
	int		alignment;
  public:
	// Direction
	static int VERTICAL;
	static int HORIZONTAL;
	// Alignment
	static int LEFT;
	static int CENTER;
	static int RIGHT;
  public:
	  FlowLayout(int dir = HORIZONTAL, int align = LEFT);
	~FlowLayout();
	virtual void add(View* view);
	void	setAlignment(int align) { alignment = align; }
	void	setVertSpacing(int v) { vspacing = v; }
	void	setHorizSpacing(int v) { hspacing = v; }
	void	setVertGap(int v) { vgap = v; }
	void	setHorizGap(int v) { hgap = v; }
	virtual void layout(int x, int y, int w, int h);
	virtual void getExtension(Dimension& d, int w, int h);
};

#endif

