/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Font.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\Font.h>
#include <sol\ClientDC.h>


HFONT  Font::create(Arg* arg, int num)
{
	memset(&lf, 0, sizeof(LOGFONT));

	lf.lfPitchAndFamily = FF_DONTCARE;
	lf.lfOutPrecision   = OUT_DEFAULT_PRECIS;
	lf.lfClipPrecision  = CLIP_DEFAULT_PRECIS;
	lf.lfQuality	    = DEFAULT_QUALITY;

	for(int i = 0; i<num; i++) {
		if(arg[i].name == XmNwidth) {
			lf.lfWidth = (int)arg[i].value; continue; 
		}
		if(arg[i].name == XmNheight) {
			lf.lfHeight = (int)arg[i].value; continue;
		}
		if(arg[i].name == XmNweight) {
			lf.lfWeight = (int)arg[i].value; continue;
		}
		if(arg[i].name == XmNorientation) {
			lf.lfOrientation = (int)arg[i].value; continue;
		}
		if(arg[i].name == XmNescapement) {
			lf.lfEscapement = (int)arg[i].value; continue;
		}
		if(arg[i].name == XmNitalic) {
			lf.lfItalic = (BYTE)arg[i].value; continue;
		}
		if(arg[i].name == XmNunderline) {
			lf.lfUnderline = (BYTE)arg[i].value; continue;
		}
		if(arg[i].name == XmNstrikeout) {
			lf.lfStrikeOut = (BYTE)arg[i].value; continue;
		}
		if(arg[i].name == XmNcharSet) {
			lf.lfCharSet = (BYTE)arg[i].value; continue;
		}
		if(arg[i].name == XmNoutputPrecision) {
			lf.lfOutPrecision = (BYTE)arg[i].value; continue;
		}
		if(arg[i].name == XmNclipPrecision) {
			lf.lfClipPrecision = (BYTE)arg[i].value; continue;
		}
		if(arg[i].name == XmNquality) {
			lf.lfQuality = (BYTE)arg[i].value; continue;
		}
		if(arg[i].name == XmNpitchAndFamily) {
			lf.lfPitchAndFamily = (BYTE)arg[i].value; continue;
		}
		if(arg[i].name == XmNfaceName){
		     strcpy(lf.lfFaceName,(const char*)(LPSTR)arg[i].value);
			continue;
		}
	}
	return	::CreateFontIndirect(&lf);
}


Font::Font()
	:GdiObject("", null)
{
}


Font::Font(Args& args)
	:GdiObject("", (HANDLE)create(args.getArgList(), args.getCount()))
{
}

Font::Font(LOGFONT* logFont)
	:GdiObject("", (HANDLE)::CreateFontIndirect(logFont))
{
	lf = *logFont;
}

Font::Font(Arg* arg, int num)
	:GdiObject("", (HANDLE)create(arg, num))
{
}

Boolean Font::create(Args& args)
{
	Boolean rc = False;
	HANDLE hfont = (HANDLE)create(args.getArgList(), args.getCount());
	if (hfont) {
		setHandle(hfont);
		rc = True;
	}
	return rc;
}

Font::~Font()
{
	HFONT hfont = (HFONT)get();
	if(hfont) {
		::DeleteObject(hfont);
	}
}

