/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ImageListView.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.07.01

#include <sol\IconedFileList.h>
#include <sol\FileFinder.h>



// Default strings for column of IconedFileList.
const char* IconedFileList::fileName = "    FileName    ";
const char* IconedFileList::fileSize = "    Size    ";
const char* IconedFileList::dateTime = "    DateTime     ";


void IconedFileList::addColumn() 
{
	StringList list;
	list.add(fileName);
	list.add(fileSize);
	list.add(dateTime);

	IntegerList format;
	format.add(LVCFMT_LEFT);
	format.add(LVCFMT_RIGHT);
	format.add(LVCFMT_CENTER);
	
	setColumn(&list, &format);
}


void IconedFileList::setDefaultColumn(const char* name1, const char* size1, 
		const char* dateTime1) 
{
	fileName = name1;
	fileSize = size1;
	dateTime = dateTime1;
	
}


IconedFileList::IconedFileList(View* parent, const char* name, Args& args)
	:ListView(parent, name, args) 
{ 
	setImageList(&imglist, LVSIL_SMALL);
	addColumn();
}


IconedFileList::~IconedFileList()
{	
	setImageList((HIMAGELIST)NULL, LVSIL_SMALL);
}

Boolean IconedFileList::create(View* parent, const char* name, Args& args) 
{
	Boolean rc = ListView::create(parent, name, args);
	setImageList(&imglist, LVSIL_SMALL);
	addColumn();

	return rc;
}


void IconedFileList::findFiles(const char* dir)
{
	clear();

	// Note: typedef WIN32_FIND_DATA FindData;
	FindData	data;

	char buffer[_MAX_PATH];
	sprintf(buffer, "%s\\*", dir);

	// Create an instance of FileFinder.
	FileFinder fileFinder(buffer);
	
	if (fileFinder.getFirst(&data)) {
		do {
			char size[20];
			char date[100];
			size[0]     = Zero;
			date[0] = Zero;

			// Get a file time from ftLastWriteTime field of FindData structure.
			SYSTEMTIME time;
			FILETIME   ltime;
			::FileTimeToLocalFileTime(&(data.ftLastWriteTime), &ltime);
			::FileTimeToSystemTime(&ltime, &time);

			sprintf(date, "%.4u/%.2u/%.2u  %.2u:%.2u:%.2u", 
					time.wYear, time.wMonth, time.wDay,
					time.wHour, time.wMinute, time.wSecond);

			LV_ITEM item;
			memset(&item, 0, sizeof(LV_ITEM));

			DWORD attr = 0;
			int	iconId = 0;

			if (data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
				iconId = imglist.getDirectoryIndex(data.cFileName);
			} else {
				iconId = imglist.getNormalFileIndex(data.cFileName);
				sprintf(size, "%d", data.nFileSizeLow);
			}

			if (strcmp(".", data.cFileName) != 0 &&
				strcmp("..", data.cFileName) != 0) {
				// Insert an item having an iconIndex and a filename into this listView.
				item.mask       = LVIF_TEXT|LVIF_IMAGE;
				item.iImage	    = iconId;
				item.pszText    = data.cFileName;
				item.cchTextMax = _MAX_PATH;
				int m = insertItem(&item);

				int n = 1;
				// Set size, filedate, filetime to the line of index m.
				setItemText(m, n++, size);
				setItemText(m, n++, date);
			}

		} while(fileFinder.getNext(&data)); 
	}
}

