/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	IconedFileList.h
 *
 *****************************************************************************/


// SOL++2000
// 2000.07.01

#ifndef _SOL_LISTVIEW
#include <sol\ListView.h>
#endif

#ifndef _SOL_SYSTEMIMAGELIST
#include <sol\SystemImageList.h>
#endif


#ifndef _SOL_ICONEDFILELIST
#define _SOL_ICONEDFILELIST

class IconedFileList :public ListView {
	static const char* fileName;
	static const char* fileSize;
	static const char* dateTime;

	SystemImageList	imglist;
	void	addColumn();

public:
	IconedFileList():ListView() { }

    IconedFileList(View* parent, const char* name, Args& args);

	~IconedFileList();

	virtual Boolean create(View* parent, const char* name, Args& args);

	void	findFiles(const char* dir);

	static void	setDefaultColumn(const char* name1, const char* size1, 
		const char* dateTime1);

	HIMAGELIST	detachImageList() {
		return setImageList((HIMAGELIST)NULL, LVSIL_SMALL);
	}
};

#endif
