/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	LinkedList.h
 *
 *****************************************************************************/

// SOL++2000
// 1999.09.04 Modified getLength and getEntry. 
#ifndef _SOL_LIST
#include <sol\List.h>
#endif

#ifndef _SOL_LISTENTRY
#include <sol\ListEntry.h>
#endif

#ifndef _SOL_LINKEDLIST
#define _SOL_LINKEDLIST

class LinkedList :public List {
	ListEntry* entry;
	Boolean		gc;

  public:
	LinkedList(Boolean gc = True);
	~LinkedList();

	Boolean	add(Object* object);

	Boolean	addLast(Object* object) { return add(object); }

	Boolean	addFirst(Object* object);

	void	clear();
	Boolean isContained(Object* object);

	Boolean	remove(Object* object);
	int		getLength() const;	// 1999.09.04

	ListEntry*  getEntry() const { return	entry; } // 1999.09.04
	Object*    	getNth(int n);

	void	sort(SortDirection dir);
	void	enableGC() {
			gc = True;
	}
	void	disableGC() {
			gc = False;
	}
	void	reverse();
};

#endif

