/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ListBox.h
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18

#ifndef _SOL_PRIMITIVE
#include <sol\Primitive.h>
#endif

#ifndef _SOL_LISTBOX
#define _SOL_LISTBOX

class ListBox :public Primitive {
	static Arg styles[];
	static const char itemsListDelim;

  public:
	ListBox():Primitive() { }
	ListBox(View* parent, HWND hwnd)
		:Primitive(parent, hwnd) { }

	ListBox(View* parent, const char* label, Args& args);
	
	int 	addString(const char* string) {
			return (int)send(LB_ADDSTRING, 0, (LPARAM)string);
	}

	virtual Boolean create(View* parent, const char* label, Args& args);

	// 1999.09.23
	void	clear() {
			send(LB_RESETCONTENT, 0, 0L);
	}
	const char*	defaultCallbackName() { return XmNdefaultActionCallback; }
	int 	deleteString(int indx) {
			return (int)send(LB_DELETESTRING, indx, 0L);
	}
	int		dir(int attr, const char* string) {
			return (int)send(LB_DIR, attr, (LPARAM)string);
	}

	void	findFiles(DWORD attr, const char* pattern);
	void	findFiles(const char* pattern);
	void	findDirectories(const char* dir);
	int		findString(int indx, const char* string) {
			return (int)send(LB_FINDSTRING, indx, (LPARAM)string);
	}
	int		findStringExact(int indx, const char* string) {
			return (int)send(LB_FINDSTRINGEXACT, indx, (LPARAM)string);
	}
	Arg*	getCallbackTable(int* num);

	int 	getCaretIndex() {
			return (int)send(LB_GETCARETINDEX, 0, 0L);
	}
	int 	getCount() {
			return (int)send(LB_GETCOUNT, 0, 0L);
	}
	int		getCurSel() {
			return (int)send(LB_GETCURSEL, 0, 0L);
	}

	char*	getCurText();

	int		getCurText(char* buffer);

	int		getHorizontalExtent() {
			return (int)send(LB_GETHORIZONTALEXTENT, 0, 0L);
	}
	long	getItemData(int indx) {
			return send(LB_GETITEMDATA, indx, 0L);
	}
	long	getItemHeight(int indx) {
			return send(LB_GETITEMHEIGHT, indx, 0L);
	}
	int		getItemRect(int indx, LPRECT rect) {
			return (int)send(LB_GETITEMRECT, indx, (LPARAM)rect);
	}
	int		getSel(int indx) {
			return (int)send(LB_GETSEL, indx, 0L);
	}
	int		getSelCount() {
			return (int)send(LB_GETSELCOUNT, 0, 0L);
	}
	int		getSelItems(int max, int array[]) {
			return (int)send(LB_GETSELITEMS, max, (LPARAM)array);
	}
	int 	getText(int indx, char* buffer) {
			return (int)send(LB_GETTEXT, indx, (LPARAM)buffer);
	}
	int 	getTextLen(int indx) {
			return (int)send(LB_GETTEXTLEN, indx, 0L);
	}
	int		getTopIndex() {
			return (int)send(LB_GETTOPINDEX, 0, 0L);
	}
	void	getValues(Args& args);

	int 	insertString(int indx, const char* string) {
			return (int)send(LB_INSERTSTRING, indx, (LPARAM)string);
	}
	void	resetContent() {
			send(LB_RESETCONTENT, 0, 0L);
	}
	int		selectString(int indx, const char* string) {
			return (int)send(LB_SELECTSTRING, indx, (LPARAM)string);
	}
	int		selItemRange(int sel, int first, int last) {
			return (int)send(LB_SELITEMRANGE, sel, MAKELPARAM(first,last));
	}
	void	setCaretIndex(int indx, int scroll) {
			send(LB_SETCARETINDEX, indx, MAKELPARAM(scroll, 0));
	}
	void	setColumnWidth(int width) {
			send(LB_SETCOLUMNWIDTH, width, 0L);
	}
	int		setCurSel(int indx) {
			return (int)send(LB_SETCURSEL, indx, 0L);
	}
	void	setHorizontalExtent(int width) {
			send(LB_SETHORIZONTALEXTENT, width, 0L);
	}
	int		setItemData(int indx, LPARAM data) {
			return (int)send(LB_SETITEMDATA, indx, data);
	}
	int		setItemHeight(int indx, int height) {
			return (int)send(LB_SETITEMHEIGHT, indx, MAKELPARAM(height,0));
	}
	int		setSel(int sel, int indx) {
			return (int)send(LB_SETSEL, sel, MAKELPARAM(indx, 0));
	}
	int		setTabStops(int num, int pos[]) {
			return (int)send(LB_SETTABSTOPS, num, (LPARAM)pos);
	}
	int		setTopIndex(int indx) {
			return (int)send(LB_SETTOPINDEX, indx, 0L);
	}
	void	setValues(Args& args);

	int 	getAnchorIndex() {
	 		return (int)send(LB_GETANCHORINDEX, 0, 0L);
	}
	long 	getLocale() {
			return send(LB_GETLOCALE, 0, 0L);
	}
	void 	setAnchorIndex(int indx) {
	 		send(LB_SETANCHORINDEX, (WPARAM)indx, 0L);
	}
	long 	setLocale(long localeId) {
	 		return send(LB_SETLOCALE, (WPARAM)localeId, 0L);
	}
};

#endif

