/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ListView.h
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18

#ifndef _SOL_PRIMITIVE
#include <sol\Primitive.h>
#endif
#ifndef _SOL_STRINGLIST
#include <sol\StringList.h>
#endif
#ifndef _SOL_IMAGELIST
#include <sol\ImageList.h>
#endif
#ifndef _SOL_INTEGERLIST		// 1998.05.10
#include <sol\IntegerList.h>
#endif

#ifndef _SOL_LISTVIEW
#define _SOL_LISTVIEW

class ListView :public Primitive {
  public:
	ListView(): Primitive() { }

  	ListView(View* parent, HWND hwnd)
		:Primitive(parent, hwnd) { }

    ListView(View* parent, const char* name, Args& args);

	Boolean	clear() {
    		return (Boolean)send(LVM_DELETEALLITEMS, 0, 0L);
	}

	virtual Boolean create(View* parent, const char* name, Args& args);	

	COLORREF getBkColor() {
    		return (COLORREF)send(LVM_GETBKCOLOR, 0, 0L);
	}
	void	setColumn(char** labels, int num);

	void	setColumn(StringList* list, int fmt = LVCFMT_LEFT);

	void	setColumn(StringList* list, IntegerList* format);

	Boolean	setBkColor(COLORREF clrBk) {
    		return (Boolean)send(LVM_SETBKCOLOR, 0, (LPARAM)clrBk);
	}

	Arg*	getCallbackTable(int* num);

	HIMAGELIST	getImageList(int iImageList) {
    		return (HIMAGELIST)send(LVM_GETIMAGELIST, (WPARAM)iImageList, 0L);
	}

	HIMAGELIST	setImageList(HIMAGELIST himl, int iImageList) {
    		return (HIMAGELIST)send(LVM_SETIMAGELIST, (WPARAM)(iImageList), (LPARAM)himl);
	}
	HIMAGELIST	setImageList(ImageList* imagelist, int iImageList) {
    		return (HIMAGELIST)send(LVM_SETIMAGELIST, (WPARAM)(iImageList), 
						(LPARAM)imagelist->getImageList());
	}

	int		getItemCount() {
    		return (int)send(LVM_GETITEMCOUNT, 0, 0L);
	}

	Boolean	getItem(LV_ITEM* pitem) {
    		return (Boolean)send(LVM_GETITEM, 0, (LPARAM)pitem);
	}

	Boolean	setItem(LV_ITEM* pitem) {
    		return (Boolean)send(LVM_SETITEM, 0, (LPARAM)pitem);
	}

	int		insertItem(LV_ITEM* pitem) {
    		return (int)send(LVM_INSERTITEM, 0, (LPARAM)pitem);
	}
	void	insertLine(int n, char** text, int num);
	void	insertLine(int n, StringList* list);

	Boolean	deleteItem(int i) {
    		return (Boolean)send(LVM_DELETEITEM, (WPARAM)i, 0L);
	}

	Boolean	deleteAllItems() {
    		return (Boolean)send(LVM_DELETEALLITEMS, 0, 0L);
	}

	Boolean	getCallbackMask() {
    		return (Boolean)send(LVM_GETCALLBACKMASK, 0, 0);
	}

	Boolean	setCallbackMask(UINT mask) {
    		return (Boolean)send(LVM_SETCALLBACKMASK, (WPARAM)mask, 0);
	}

	int 	getNextItem(int i, int flags) {
    		return (int)send(LVM_GETNEXTITEM, (WPARAM)i, MAKELPARAM(flags, 0));
	}
	int		findItem(int iStart, LV_FINDINFO* plvfi) {
    		return (int)send(LVM_FINDITEM, (WPARAM)iStart, (LPARAM)plvfi);
	}

	Boolean	getItemRect(int i, RECT* prc, int code) {
			return (Boolean)send(LVM_GETITEMRECT, (WPARAM)(int)(i), 
           		((prc) ? (((RECT FAR *)(prc))->left = (code),(LPARAM)(RECT FAR*)(prc)) : (LPARAM)(RECT FAR*)NULL));
 	}

	Boolean	setItemPosition(int i, int x, int y) {
    		return (Boolean)send(LVM_SETITEMPOSITION, (WPARAM)i, MAKELPARAM((x), (y)));
	}

	Boolean	getItemPosition(int i, POINT* ppt) {
    		return (Boolean)send(LVM_GETITEMPOSITION, (WPARAM)i, (LPARAM)ppt);
	}

	int		getStringWidth(char* psz) {
    		return (int)send(LVM_GETSTRINGWIDTH, 0, (LPARAM)psz);
	}

	int		hitTest(LV_HITTESTINFO* pinfo) {
    		return (int)send(LVM_HITTEST, 0, (LPARAM)pinfo);
	}

	Boolean	ensureVisible(int i, Boolean fPartialOK) {
    		return (Boolean)send(LVM_ENSUREVISIBLE, (WPARAM)i, MAKELPARAM((fPartialOK), 0));
	}

	Boolean	scroll(int dx, int dy) {
    		return (Boolean)send(LVM_SCROLL, (WPARAM)dx, (LPARAM)dy);
	}

	Boolean	redrawItems(int iFirst, int iLast) {
    		return (Boolean)send(LVM_REDRAWITEMS, (WPARAM)iFirst, (LPARAM)iLast);
	}

	Boolean	arrange(UINT code) {
    		return (Boolean)send(LVM_ARRANGE, (WPARAM)code, 0L);
	}

	HWND	editLabel(int i) {
    		return (HWND)send(LVM_EDITLABEL, (WPARAM)i, 0L);
	}

	HWND 	getEditControl() {
    		return (HWND)send(LVM_GETEDITCONTROL, 0, 0L);
	}

	Boolean	getColumn(int indx, LV_COLUMN* pcol) {
    		return (Boolean)send(LVM_GETCOLUMN, (WPARAM)indx, (LPARAM)pcol);
	}

	Boolean 	setColumn(int indx, LV_COLUMN* pcol) {
    		return (Boolean)send(LVM_SETCOLUMN, (WPARAM)indx, (LPARAM)pcol);
	}

	int 	insertColumn(int indx, LV_COLUMN* pcol) {
    		return (int)send(LVM_INSERTCOLUMN, (WPARAM)indx, (LPARAM)pcol);
	}

	Boolean	deleteColumn(int indx) {
    		return (Boolean)send(LVM_DELETECOLUMN, (WPARAM)indx, 0);
	}

	int		getColumnWidth(int indx) {
    		return (int)send(LVM_GETCOLUMNWIDTH, (WPARAM)indx, 0);
	}

	Boolean	setColumnWidth(int column, int cx) {
    		return (Boolean)send(LVM_SETCOLUMNWIDTH, (WPARAM)column, MAKELPARAM((cx), 0));
	}

	HIMAGELIST createDragImage(int i, POINT* upLeft) {
    		return (HIMAGELIST)send(LVM_CREATEDRAGIMAGE, (WPARAM)i, (LPARAM)upLeft);
	}

	Boolean	getViewRect(RECT* rc) {
    		return (Boolean)send(LVM_GETVIEWRECT, 0, (LPARAM)rc);
	}

	COLORREF getTextColor() {
    		return (COLORREF)send(LVM_GETTEXTCOLOR, 0, 0L);
	}

	Boolean	setTextColor(COLORREF textColor) {
    		return (Boolean)send(LVM_SETTEXTCOLOR, 0, (LPARAM)textColor);
	}

	COLORREF getTextBkColor()  {
    		return (COLORREF)send(LVM_GETTEXTBKCOLOR, 0, 0L);
	}

	Boolean	setTextBkColor(COLORREF textBk) {
    		return (Boolean)send(LVM_SETTEXTBKCOLOR, 0, (LPARAM)textBk);
 	}

	int		getTopIndex() {
    		return (int)send(LVM_GETTOPINDEX, 0, 0);
	}

	int 	getCountPerPage() {
    		return (int)send(LVM_GETCOUNTPERPAGE, 0, 0);
	}

	Boolean	getOrigin(POINT* ppt) {
    		return (Boolean)send(LVM_GETORIGIN, 0, (LPARAM)ppt);
	}

	Boolean 	update(int i) {
    		return (Boolean)send(LVM_UPDATE, (WPARAM)i, 0L);
	}

	void	setItemState(int i, int data, int mask);
	

	UINT	getItemState(int i, int mask) {
   			return (UINT)send(LVM_GETITEMSTATE, (WPARAM)i, (LPARAM)mask);
	}
	 
	void	getItemText(int i, int subItem, char* text, int textMax);

	void 	setItemText(int i, int subItem, char* text);
	
	void	setItemCount(WPARAM cItems) {
  			send(LVM_SETITEMCOUNT, (WPARAM)cItems, 0);
	}
 
	Boolean	sortItems(PFNLVCOMPARE compare, void* param) {
  			return (Boolean)send(LVM_SORTITEMS, (WPARAM)param,
  					(LPARAM)compare);
	}
 
	void	setItemPosition32(int i, long x, long y) { 
			POINT pos = {x,y}; 
    		send( LVM_SETITEMPOSITION32, (WPARAM)i, (LPARAM)&pos);
	}

	UINT	getSelectedCount() {
    		return (UINT)send(LVM_GETSELECTEDCOUNT, 0, 0L);
	}

	DWORD 	getItemSpacing(Boolean fSmall) {
        	return (DWORD)send(LVM_GETITEMSPACING, fSmall, 0L);
	}

	Boolean	getISearchString(char* lpsz) {
			return (Boolean)send(LVM_GETISEARCHSTRING, 0, (LPARAM)(LPTSTR)lpsz);
	}

	long	getExtendedViewStyle() {
			return (long)send(LVM_GETEXTENDEDLISTVIEWSTYLE, 0, 0);
	}

	void	setExtendedViewStyle(long style) {
			send(LVM_SETEXTENDEDLISTVIEWSTYLE, 0, style);
	}
	Boolean	getSubItemRect(int iItem, int iSubItem, int code, RECT* prc) {
			return (Boolean)send(LVM_GETSUBITEMRECT, (WPARAM)(int)(iItem), 
                ((prc) ? ((((LPRECT)(prc))->top = iSubItem), 
				(((LPRECT)(prc))->left = code), (LPARAM)(prc)) : (LPARAM)(LPRECT)NULL));
	}
	int		subItemHitTest(LVHITTESTINFO* plvhti) {
			return (int)send(LVM_SUBITEMHITTEST, 0, (LPARAM)plvhti);
	}

	Boolean	setColumnOrderArray(int iCount, int* pi) {
			return (Boolean)send(LVM_SETCOLUMNORDERARRAY, (WPARAM)iCount, (LPARAM)pi);
	}

	Boolean	getColumnOrderArray(int iCount, int* pi) {
			return (Boolean)send(LVM_GETCOLUMNORDERARRAY, (WPARAM)iCount, (LPARAM)pi);
	}

	int		setHotItem(int i) {
			return (int)send(LVM_SETHOTITEM, (WPARAM)i, 0);
	}

	int		getHotItem() {
			return (int)send(LVM_GETHOTITEM, 0, 0);
	}

	HCURSOR	setHotCursor(HCURSOR hcur) {
			return (HCURSOR)send(LVM_SETHOTCURSOR, 0, (LPARAM)hcur);
	}

	HCURSOR	getHotCursor() {
			return (HCURSOR)send(LVM_GETHOTCURSOR, 0, 0);
	}

	DWORD	approximateViewRect(int iWidth, int iHeight, int iCount) {
        return (DWORD)send(LVM_APPROXIMATEVIEWRECT, iCount, MAKELPARAM(iWidth, iHeight));
	}

	Boolean	setWorkAreas(RECT* prc) {
			return (Boolean)send(LVM_SETWORKAREAS, 0, (LPARAM)prc);
	}
};

#endif
