/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	MdiChild.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\Application.h>
#include <sol\MdiChild.h>


MdiChild::MdiChild(MdiClient* parent, const char* title, Args& args)
	:Composite(parent)
{
	char* className = (char*)args.get(XmNclassName);
	if(className == NULL) {
		className = "MdiChild";
		args.set(XmNclassName, className);
	}
	Application::registerClass(args);

 	MDICREATESTRUCT cs;
	cs.szClass = className;
	cs.szTitle = title;
	cs.hOwner  = Application::getInstance();
	cs.x	   = (int) args.get(XmNx),
	cs.y	   = (int) args.get(XmNy),
	cs.cx      = (int) args.get(XmNwidth),
	cs.cy      = (int) args.get(XmNheight),
	cs.style   = args.get(XmNstyle);
	cs.lParam  = NULL;
	HWND  hwnd = (HWND)parent -> send(WM_MDICREATE, 0, (LONG)&cs);
	setWindow(hwnd);
	Application::add(hwnd, this);

	const char* menuName = (char*) args.get(XmNmenuName);
	if(!menuName) {
		menuName = title;
	}
	menuBar   = new MenuBar(this, menuName);
	subMenuId = (int) args.get(XmNmenuId);

	setValues(args);

	addEventHandler(WM_MDIACTIVATE, this,
			(Handler)&MdiChild::mdiActivate, NULL);
	addEventHandler(WM_MDIDESTROY, this,
			(Handler)&MdiChild::destroy, NULL);
	addEventHandler(WM_SIZE, this, 
	       (Handler)&MdiChild::size, NULL); 

	addCallback(XmNhorizScrollCallback, (Key)hwnd, this,
		(Callback)&Composite::doHorizScroll, NULL);
	addCallback(XmNvertScrollCallback, (Key)hwnd, this,
		(Callback)&Composite::doVertScroll,  NULL);

	parent -> activate(this);
}



Boolean MdiChild::create(MdiClient* parent, const char* title, Args& args)
{
	Boolean rc = False;
	View::setParent(parent);

	char* className = (char*)args.get(XmNclassName);
	if(className == NULL) {
		className = "MdiChild";
		args.set(XmNclassName, className);
	}
	Application::registerClass(args);

 	MDICREATESTRUCT cs;
	cs.szClass = className;
	cs.szTitle = title;
	cs.hOwner  = Application::getInstance();
	cs.x	   = (int) args.get(XmNx),
	cs.y	   = (int) args.get(XmNy),
	cs.cx      = (int) args.get(XmNwidth),
	cs.cy      = (int) args.get(XmNheight),
	cs.style   = args.get(XmNstyle);
	cs.lParam  = NULL;
	HWND  hwnd = (HWND)parent -> send(WM_MDICREATE, 0, (LONG)&cs);
	
	if (hwnd) {
		rc = True;
		setWindow(hwnd);
		Application::add(hwnd, this);

		const char* menuName = (char*) args.get(XmNmenuName);
		if(!menuName) {
			menuName = title;
		}
		menuBar   = new MenuBar(this, menuName);
		subMenuId = (int) args.get(XmNmenuId);

		setValues(args);

		addEventHandler(WM_MDIACTIVATE, this,
			(Handler)&MdiChild::mdiActivate, NULL);
		addEventHandler(WM_MDIDESTROY, this,
			(Handler)&MdiChild::destroy, NULL);
		addEventHandler(WM_SIZE, this, 
			(Handler)&MdiChild::size, NULL); 

		addCallback(XmNhorizScrollCallback, (Key)hwnd, this,
			(Callback)&Composite::doHorizScroll, NULL);
		addCallback(XmNvertScrollCallback, (Key)hwnd, this,
			(Callback)&Composite::doVertScroll,  NULL);

		parent -> activate(this);
	}
	return rc;
}


long MdiChild::size(Event& event)
{
	defaultProc(event);	

	justifyScrollRange();
	return NULL;
}


long MdiChild::mdiActivate(Event& event)
{
	MdiClient* mdiClient = (MdiClient*)getParent();
	MdiFrame*  mdiFrame  = (MdiFrame*)mdiClient->getParent();

	HMENU  hmenu   = NULL;
	HMENU  subMenu = NULL;
	WPARAM wParam  = event.getWParam();
	HWND   active  = (HWND)event.getLParam();
	if(active == getWindow()) {
		hmenu   = menuBar -> get();
		subMenu = ::GetSubMenu(hmenu, subMenuId);
	}
	else {
		hmenu   = mdiFrame-> getMenuBar() -> get();
		subMenu = ::GetSubMenu(hmenu, mdiFrame -> getSubMenuId());
	}
	mdiClient -> setMenu(hmenu, subMenu);
	::DrawMenuBar(mdiFrame->getWindow());
	return NULL;
}


long MdiChild::destroy(Event& event)
{
	MdiClient*  mdiClient = (MdiClient*)getParent();
	if(mdiClient)
		mdiClient -> destroy(event);
	return NULL;
}


long MdiChild::defaultProc(Event& event)
{
	return ::DefMDIChildProc(getWindow(),
				event.getMessage(),
				event.getWParam(),
				event.getLParam());
}


void  MdiChild::setViewId(int vid)
{
	int	id = (int)getWindowLong(GWL_ID);
 	setId(id);
}


MdiFrame* MdiChild::getMdiFrame()
{
	View* parent = getParent();
	MdiFrame* frame = NULL;
	if(parent) {
		frame = (MdiFrame*)(parent->getParent());
	}
	return frame;
}

