/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Node.h
 *
 *****************************************************************************/

// SOL++2000

#ifndef _SOL_LINKEDLIST
#include <sol\LinkedList.h>
#endif

#ifndef _SOL_NODE
#define _SOL_NODE

class Node :public Object {
	float   x;
	float   y;
	char* 	name;
	void*   data;
	Node*	parent;
	LinkedList*  children;
  public:
	Node(const char* name, int nid);
	Node(Node* parent, const char* name, int nid);
	~Node();
	void 	add(Node* node) { children -> add(node); }
	int  	configure(int x, int y);
	LinkedList*   getChildren() { return children; }
	void*   getData() { return data; }
	char* 	getName() { return name; }
	Node*	getParent() { return parent; }
	float	getX() { return x; }
	float   getY() { return y; }
	float 	reconfigure();
	Node* 	search(const char* name);
	Node*	search(int nid);
	void	setData(void* data1) { data = data1; }
	void	setParent(Node* parent1) { parent = parent1; }
};

#endif

