/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Profile.cpp
 *
 *****************************************************************************/

// SOL++2000

// 2000.07.19 Modified to fix a memory leak.

#include <sol\Profile.h>
#include <sol\Application.h>


Profile::Profile(const char* fileName1)
{
	fileName = NULL;

	if(fileName1) {
		fileName = new char[strlen(fileName1)+1];
		strcpy(fileName, fileName1);
	}
	else {
		//
		//char* name = new char[_MAX_PATH];
		char name[_MAX_PATH];

		::GetModuleFileName(NULL, name, _MAX_PATH);
		char* bs= strrchr(name, '\\');
 		if(bs) {
			bs++;
			char* dot = strrchr(bs, '.');
			if(dot) {
		 		*dot = NULL;
			}
			fileName = new char[strlen(bs)+1];
			strcpy(fileName, bs); 		
		}
		else {
	 		fileName = new char[1];
			fileName[0] = Zero;
		}
	}
}


Profile::~Profile()
{
	delete [] fileName;
}


int Profile::get(const char* section, const char* entry, int defvalue)
{
	return ::GetPrivateProfileInt(section, entry,defvalue, fileName);
}


// Return the whole string of the right hand side of entry
// In case of
// [Section]
// entry=val1 val2 val3
// return "val1 val2 val2"

int Profile::get(const char* section, const char* entry,
		char* buff, UINT bufflen)
{
	return ::GetPrivateProfileString(section, entry, "", 
				buff, bufflen, fileName);
}


int Profile::get(const char* section, const char* entry, char* defvalue, 
		char* buff, UINT bufflen)
{
	return ::GetPrivateProfileString(section, entry, defvalue, 
				buff, bufflen, fileName);
}


int Profile::getGeometry(int* x, int* y, int* w, int* h)
{
  	*x = CW_USEDEFAULT;
	*y = CW_USEDEFAULT;
	*w = CW_USEDEFAULT;
	*h = CW_USEDEFAULT;

	char geo[40];
	int len = get("Windows", "Geometry", "", geo, sizeof(geo));
	if(len) {
   		sscanf(geo, "%d %d %d %d", x, y, w, h);
	}
	return len;
}

int Profile::set(const char* section, const char* entry, int value)
{
	char buff[20];
	sprintf(buff, "%d", value);
	return ::WritePrivateProfileString(section, entry,
			buff, fileName);
}


int Profile::set(const char* section, const char* entry, char* value)
{
	return ::WritePrivateProfileString(section, entry,
			value, fileName);
}


void Profile::setGeometry(int x, int y, int w, int h)
{
	char geo[40];
	sprintf(geo, "%d %d %d %d", x, y, w, h);
	set("Windows", "Geometry", geo);
}

void Profile::setGeometry(RECT* r)
{
	char geo[40];
	sprintf(geo, "%d %d %d %d", r->left, r->top,
		r->right - r->left, r->bottom - r->top);
	set("Windows", "Geometry", geo);
}

