/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	PropertyDialog.h
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18

#ifndef _SOL_POPUPVIEW
#include <sol\PopupView.h>
#endif

#ifndef _SOL_PROPERTYPAGE
#include <sol\PropertyPage.h>
#endif

#ifndef _SOL_PROPERTYDIALOG
#define _SOL_PROPERTYDIALOG

class PropertyDialog :public PopupView {
	int	pages;
	int	curIndex;
	PROPSHEETPAGE*   psp;
	PROPSHEETHEADER* psh;

  public:
	PropertyDialog(): PopupView() { }

	PropertyDialog(View* parent, const char* title, Args& args);
	~PropertyDialog();

	virtual Boolean create(View* parent, const char* title, Args& args);

	void	popup(Action& action);
	BOOL	addPage(PropertyPage* page) ;
	PROPSHEETPAGE* getCurPage(); 
	
	void	setValues(Args& args);
	int		getCurIndex() { return curIndex; }

	void	setCurSel(int indx, PropertyPage* page) {
   			send(PSM_SETCURSEL, indx, (LPARAM)page->getPageHandle());
	}
	void	removePage(int indx, PropertyPage* page) {
			send(PSM_REMOVEPAGE, indx, (LPARAM)page->getPageHandle());
	}
	void	changed(PropertyPage* page) {
			send(PSM_CHANGED, (WPARAM)page->getPageHandle(), 0);
	}	

	void	unChanged(PropertyPage* page) {
			send(PSM_UNCHANGED, (WPARAM)page->getPageHandle(), 0);
	}	
	void	restartWindows() {
			send(PSM_RESTARTWINDOWS, 0, 0);			
	}
	void	rebootSystem() {
			send(PSM_REBOOTSYSTEM, 0, 0);			
	}
	void	cancelToClose() {
			send(PSM_CANCELTOCLOSE, 0, 0);			
	}
	void	querySiblings(WPARAM wParam, LPARAM lParam) {
			send(PSM_QUERYSIBLINGS, wParam, lParam);
	}
	void	apply() {
			send(PSM_APPLY, 0, 0);				
	}	
	void	setTitle(WPARAM style, char* title) {
			send(PSM_SETTITLE, style, (LPARAM)title);
	}
	void	setWizButtons(LPARAM flags) {
			send(PSM_SETWIZBUTTONS, 0, (LPARAM)flags);
	}
	void	pressButton(int idbutton) {
			send(PSM_PRESSBUTTON, idbutton, 0);
	}
	void	setCurSelByID(int id) {
			send(PSM_SETCURSELID, 0, (LPARAM)id);
	}
	void	setFinishText(char* text) {
			send(PSM_SETFINISHTEXT, 0, (LPARAM)text);
	}
	HWND	getTabControl() {
			return (HWND)send(PSM_GETTABCONTROL, 0, 0);
	}
	BOOL	isDialogMessage(MSG* pMsg) {
			return (BOOL)send(PSM_ISDIALOGMESSAGE, 0, (LPARAM)pMsg);
	}
	HWND	getCurrentPageHwnd() {
			return (HWND)send(PSM_GETCURRENTPAGEHWND, 0, 0L);
	}
};

#endif

