/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	PropertyPage.h
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18

#ifndef  _SOL_POPUPVIEW
#include <sol\PopupView.h>
#endif

#ifndef _SOL_PROPERTYPAGE
#define _SOL_PROPERTYPAGE
class PropertyDialog;

class PropertyPage :public PopupView {
	static  PropertyPage* self;
	PROPSHEETPAGE* psp;
	HPROPSHEETPAGE hpage;

	static UINT CALLBACK  pageCallback(HWND  hwnd, 
				UINT message, LPPROPSHEETPAGE  ppsp);

	static BOOL  procedure(HWND hdlg, UINT message, 
				WPARAM wParam, LPARAM lParam);
  protected:
	virtual long	initDialog(Event& event);

	virtual long	command(Event& event);
	virtual long	notify(Event& event);

	void	setSelf(PropertyPage* dlg) {
		self = dlg;
	}

public:
	PropertyPage(): PopupView() { }
	PropertyPage(PropertyDialog* parent, const char* title, Args& args);
	~PropertyPage(); 

	virtual Boolean  create(PropertyDialog* parent, const char* title, Args& args);

	PROPSHEETPAGE* getPage() { return psp; }
	HPROPSHEETPAGE getPageHandle() { return hpage; }
	void	addCallback(const char* name, Object* object,
		       Callback proc, void* data);
	Arg*	getCallbackTable(int* num);
	void	setMsgResult(long result);
};

#endif
