/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	QuickSorter.h
 *
 *****************************************************************************/

// SOL++2000
// 1999.09.04 Modifed run method to match the run method in Thread class.

#ifndef _SOL_SORTER
#include <sol\Sorter.h>
#endif

#ifndef _SOL_QUICKSORTER
#define _SOL_QUICKSORTER

class View;

#define  WM_SORTED	(WM_USER+555)

class QuickSorter :public Sorter {
	View*	view;		// View to receive a completion message
	long	message;	// Thread completion message to be sent the view.

	int*	integers;
	char**	strings;
	Object** objects;
	int		size;

	void	sort(int* a, int lo0, int hi0);
	void	sort(char* a[], int lo0, int hi0);
	void	sort(Object* a[], int lo0, int hi0);

public:
	QuickSorter(View* view1 = NULL, long message1 = WM_SORTED);
	~QuickSorter() { }

	void sort(int* array1, int size1);
	void sort(char** array1, int size1);
	void sort(Object** objects1, int size1);

	virtual void run(); // 1999.09.04 Modifed
};


#endif
