/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Sash.h
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18

#ifndef _SOL_PRIMITIVE
#include <sol\Primitive.h>
#endif

#ifndef _SOL_RESOURCE
#include <sol\Resource.h>
#endif

#ifndef _SOL_SASH
#define _SOL_SASH

class Sash :public Primitive {
  private:
	int		x, y;
	int		px, py;
	BOOL	capturing;
	int		thickness;
	int		direction;

  public:
	static	int VERTICAL;
	static	int HORIZONTAL;

 private:
	long 	paint(Event& event);
	long	leftButtonDown(Event&  event);
	long	leftButtonUp(Event&  event);
	long	mouseMove(Event&  event);
	long	size(Event&  event);

  public:
	Sash():Primitive() { }
	
	Sash(View* parent, const char* label, Args& args);
	
	~Sash() { }

	virtual Boolean create(View* parent, const char* label, Args& args);

	void	addCallback(const char* name, Object* object, 
			Callback callback, void* data);
	int		getThickness() { return thickness; }
	void	setThickness(int val) { thickness = val; }
	
};

#endif
