/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Text.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.16


#include <sol\ApplicationView.h>
#include <sol\PaintDC.h>
#include <sol\FlowLayout.h>

#include <sol\BorderLayout.h>
#include <sol\TextField.h>
#include <sol\ScrolledText.h>
#include <sol\PushButton.h>
#include <sol\Sheet.h>
#include <sol\Panel.h>

class AppView :public ApplicationView {

	BorderLayout blayout;
	FlowLayout   flowLayout;
	PushButton*	 save;
	TextField*	 name;
	PushButton*	 open;
	Panel*		 north;
	PushButton*		 south;
	PushButton*		east;
	PushButton*		west;
	ScrolledText*	center;

  public:
        AppView(Application& applet, const char* label, Args& args)
		:ApplicationView(applet, label, args)
	{
		Args ar;
		setLayout(&blayout);

		north = new Panel(this, "", ar);
		north -> setLayout(&flowLayout);
		flowLayout.setAlignment(FlowLayout::CENTER);
		flowLayout.setHorizSpacing(20);
		flowLayout.setHorizGap(20);
		ar.reset();
		north -> add(open = new PushButton(north, "Open", ar));

		ar.reset();
		north -> add(save = new PushButton(north, "Save", ar));
		ar.reset();
		north -> add(name = new TextField(north, "Name", ar));

		ar.reset();
		add(north, BorderLayout::SOUTH);
		ar.reset();
		south = new PushButton(this, "south", ar);
		add(south, BorderLayout::NORTH);

		ar.reset();
		west = new PushButton(this, "west", ar);
		add(west, BorderLayout::WEST);
		ar.reset();
		east = new PushButton(this, "east", ar);
		add(east, BorderLayout::EAST);

		ar.reset();
		center = new ScrolledText(this, "center", ar);
		add(center, BorderLayout::CENTER);
		pack();
	}

	~AppView() {
		delete	 save;
		delete	 name;
		delete	 north;
		delete	south;
		delete	east;
		delete	west;
		delete	center;
	}
};



void	Main(int argc, char** argv)
{
	const char* name = "AppView";
	Application applet(name, argc, argv);

	Args args;
	AppView appview(applet, name, args);
	appview.realize();

	applet.run();
}

