/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Console.cpp
 *
 *****************************************************************************/


// SOL++2000 
// 2000.02.18

#include <sol\ApplicationView.h>
#include <sol\ScrolledText.h>

#include <sol\DesktopWindow.h>
#include <sol\Profile.h>
#include <sol\Font.h>
#include <sol\Paintdc.h>
#include <sol\Stdio.h>
#include <sol\ClientDC.h>

// 1997.07.19
#include <sol\Mutex.h>
#include "resource.h"


class Console :public ApplicationView {
	Profile  profile;
	Font	 font;
	ScrolledText sctext;
	void	clear(Action& action) { sctext.setText(""); }
	long	close(Event& event);

  public:
	Console(Application& applet, const char* name, Args& args);
};


Console::Console(Application& applet, const char* name, Args& args)
	:ApplicationView(applet, name, args)
{
	Args ar;

	int fontSize = -14;
	if(GetSystemMetrics(SM_CXSCREEN) <= 1024 &&
			   GetSystemMetrics(SM_CYSCREEN) <= 768) {
		fontSize = -12;
	}
	//<modified date="2000.02.18" author="atlan">
	ClientDC dc(this);
	UINT charSet = dc.getTextCharsetInfo(NULL);
	ar.reset();
	ar.set(XmNheight, fontSize);
	ar.set(XmNcharSet, (ulong)charSet);
	font.create(ar);
	//</modified>

	ar.reset();
	sctext.create(this, "", ar);
	// Add sctext to the default layout manager.
	add(&sctext);

	sctext.limitText(32000); 
	sctext.setFont(&font);
	sctext.addCallback(XmNmaxTextCallback, this, (Callback)&Console::clear, null);
		
	addCallback(XmNmenuCallback, ID_CLEAR, this, 
		(Callback)&Console::clear, null);
	addCallback(XmNmenuCallback, ID_EXIT, this, 
		(Callback)&Console::exit, null);

	addEventHandler(WM_CLOSE, this, (Handler)&Console::close, NULL);

	DesktopWindow desktopw;
	desktopw.setProp("SCROLLED_TEXT", (HANDLE)sctext.getWindow());

	restorePlacement();
}


long Console::close(Event& event)
{
	DesktopWindow desktopw;
	desktopw.removeProp("SCROLLED_TEXT");
	savePlacement();
	return defaultProc(event);
}


// Console Main
void	Main(int argc, char** argv)
{
	const char* appClass = "Console";
	Application applet(appClass, argc, argv);
		
	// 1997.07.19
	HWND hwnd = FindWindow(appClass, appClass);
	if(hwnd == NULL) {
		Mutex mutex(NULL, TRUE, appClass);
		if(mutex.wait() == WAIT_OBJECT_0) {
		
			Args args;
			args.set(XmNclassName, appClass);
			Console console(applet, appClass, args);
			console.realize();
			applet.run();
		}
	}
	else {
		SetForegroundWindow(hwnd);
	}
}
