/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Explorer.cpp
 *
 *****************************************************************************/


// SOL++2000 
// 2000.02.18

#include <sol\ApplicationView.h>
#include <sol\ComboBox.h>
#include <sol\Label.h>

#include "Dirtreev.h"

class Explorer :public ApplicationView {
	Label		 label;
	ComboBox	 drives;
	DirTreeView  treev;
	void	buildDriveList();
	long	size(Event& event);
	void	driveSelected(Action& action);
	void	expanding(Action& action);
  public:
	Explorer(Application& applet, const char* name, Args& args);
};


Explorer::Explorer(Application& applet, const char* name, Args& args)
		:ApplicationView(applet, name, 
			args.set(XmNbackground, (COLOR_BTNFACE+1))	)
{
	Args ar;
	label.create(this, "Drive:", ar);

	ar.reset();
	ar.set(XmNstyle, (ulong)CBS_DROPDOWNLIST);
	drives.create(this, "", ar);

	drives.addCallback(XmNselChangeCallback, this,
		(Callback)&Explorer::driveSelected, NULL);
	buildDriveList();

	ar.reset();
	ar.set(XmNexStyle, (ulong)WS_EX_CLIENTEDGE);
	ar.set(XmNstyle, (ulong)TVS_HASBUTTONS|TVS_HASLINES|TVS_LINESATROOT);
	treev.create(this, "", ar);

	treev.addCallback(XmNitemExpandingCallback, this,
		(Callback)&Explorer::expanding, NULL);

	char dir[_MAX_PATH];
	::GetCurrentDirectory(sizeof(dir), dir);
	char* p = strchr(dir, ':');
	if(p++) {
		*p = NULL;
	}
	int pos = drives.findStringExact(-1, dir);
	drives.selectString(pos, dir);

	HTREEITEM root = treev.addItem(NULL, TVI_ROOT, dir);

	treev.findDirectories(root, dir, 0, 2);
	treev.sortChildren(root, TRUE);
	treev.expand(root, TVE_EXPAND);
}


void Explorer::buildDriveList()
{
	char path[10];
	DWORD d = ::GetLogicalDrives();
	for(int i = 0; i<26; i++) {
		if(d & 1) {
			sprintf(path, "%c:", 'A'+i);
			drives.addString(path);
		}
		d = d >> 1;
	}
}


void Explorer::driveSelected(Action& action)
{
	char dir[10];
	int idx = drives.getCurSel();
	if(idx != CB_ERR) {
		drives.getLBText(idx, dir);
		treev.deleteAllItems();
		HTREEITEM root = treev.addItem(NULL, TVI_ROOT, dir);
		treev.findDirectories(root, dir, 0, 2);
		treev.sortChildren(root, TRUE);
		treev.expand(root, TVE_EXPAND);
	}
}

long Explorer::size(Event& event)
{
	LPARAM s = event.getLParam();
	int h = drives.getItemHeight(-1);
	RECT r;
	label.getWindowRect(&r);
	int w = r.right - r.left;
	label.reshape(0, 0, w,  h);
	drives.reshape(w, 0, 100, 100); 
	treev.reshape(0, h+6, LOWORD(s), HIWORD(s)-h-6);
	return 0L;
}


void Explorer::expanding(Action& action)
{							 
	Event& event = action.getEvent();	
	NM_TREEVIEW* nmtreev = (NM_TREEVIEW*)event.getLParam();
	HTREEITEM htreeItem = nmtreev->itemNew.hItem;
	char dir[_MAX_PATH];
	dir[0] = NULL;
	// Get fullpathname of the selected node
	treev.getHierachy(htreeItem, dir, "\\");
	// Delete all children
	treev.deleteChildren(htreeItem);
	// Builde a tree for the subdirectory
	treev.findDirectories(htreeItem, dir, 0, 2);
	treev.sortChildren(htreeItem, TRUE);
}

void	Main(int argc, char** argv)
{
	const char* appClass = "Explorer";
	Application applet(appClass, argc, argv);

	Args args;
	Explorer explorer(applet, appClass, args);
	explorer.realize();

	applet.run();
}

