/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	GridLayout.cpp
 *
 *****************************************************************************/


// SOL++2000 
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\PaintDC.h>
#include <sol\GridLayout.h>
#include <sol\FlowLayout.h>

#include <sol\PushButton.h>
#include <sol\Sheet.h>

class AppView :public ApplicationView {
	PushButton		fbutton[3];
	PushButton		buttons[5];
	GridLayout		gridLayout;
	FlowLayout		flowLayout;
	Sheet			panel;
  public:
        AppView(Application& applet, const char* label, Args& args)
		:ApplicationView(applet, label, args),
			gridLayout(3, 2),
			flowLayout(FlowLayout::VERTICAL)
	{
		Args ar;
		setLayout(&gridLayout);
		//ar.set(XmNstyle, WS_CHILD);

		panel.create(this, "", ar);
		panel.setVisible(True);
		panel.setLayout(&flowLayout);
		
		ar.reset();
		fbutton[0].create(&panel, "111", ar);
		ar.reset();
		fbutton[1].create(&panel, "222", ar);
		ar.reset();
		fbutton[2].create(&panel, "333", ar);

		panel.add(fbutton[0]);
		panel.add(fbutton[1]);
		panel.add(fbutton[2]);

		for(int i = 0; i<5; i++) {
			char string[128];

			sprintf(string, "Button %d", i);
			ar.reset();
			buttons[i].create(this, string, ar);
			add(buttons[i]);
		}
		add(panel);
	}
};


void	Main(int argc, char** argv)
{
	const char* name = "AppView";
	Application applet(name, argc, argv);
	Args args;
	AppView appview(applet, name, args);
	appview.realize();
	applet.run();
}

