/******************************************************************************
 *
 * Copyright (c) 2000	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ProxySetting.cpp
 *
 *****************************************************************************/

// SOL++2000 Sample
// 2000/11/11

#include "ProxySetting.h"
#include <sol\ClientDC.h>

ProxySetting::ProxySetting()
{

}


Boolean ProxySetting::create(View* parent, const char* label, Args& args)
{
	Boolean rc = True;

	PopupView::create(parent, label, args);

	Args ar;
	ar.set(XmNheight, (-12));
	font.create(ar);


	ar.reset();
	host.create(this, "HOST", ar);
	host.setFont(font);

	ar.reset();
	hostField.create(this, "", ar);
	hostField.setFont(font);
	hostField.limitText(255);

	ar.reset();
	port.create(this, "PORT", ar);
	port.setFont(font);


	ar.reset();
	portField.create(this, "", ar);
	portField.setFont(font);
	portField.limitText(5);


	ar.reset();
	ar.set(XmNid, IDOK);
	ok.create(this, "OK", ar);
	ok.setFont(font);

	ar.reset();
	ar.set(XmNid, IDCANCEL);
	cancel.create(this, "Cancel", ar);
	cancel.setFont(font);
	cancel.addCallback(XmNactivateCallback, this, 
		(Callback)&ProxySetting::popdown, NULL);
	resize();

	memset(hostName, 0, sizeof(hostName));

	return rc;
}


ProxySetting::~ProxySetting()
{
}

long ProxySetting::size(Event& event)
{
	int w, h;
	event.getSize(w, h);

	ClientDC cdc(this);
	HFONT prev = (HFONT)cdc.select(font);
	int h1 = cdc.getTextHeight() * 7/4;
	int fh = cdc.getTextHeight() + 8;
	cdc.select(prev);

	int w1 = (w - 40)/3;
	int ww, hh;
	host.getSize(ww, hh);

	host.reshape(10, 10, ww, fh);
	hostField.reshape(ww, 10, w-ww-20, fh);

	port.reshape(10, 10+h1+10, ww, fh);
	portField.reshape(ww, 10+h1+10, w-ww-20, fh);

	ok.reshape(20, h-h1-10, w1, h1);
	cancel.reshape(20+w1*2, h-h1-10, w1, h1);

	update(NULL);

	return 0L;
}

void ProxySetting::addOkCallback(View* view, Callback callback)
{
	ok.addCallback(XmNactivateCallback, view,
			callback, null);
}
