/******************************************************************************
 *
 * Copyright (c) 2000	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	IconExtractor.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.05.30


#include <sol\ApplicationView.h>
#include <sol\ListView.h>
#include <sol\Stdio.h>
#include <sol\PaintDC.h>
#include <sol\ClientDC.h>
#include <sol\FileDialog.h>


class IconExtractor :public ApplicationView {
	ListView		listView;
	FileDialog		fileDialog;
	ImageList		imageList;

	void	open(Action& action);
  public:
	IconExtractor(Application& applet, const char* name, Args& args);

	~IconExtractor() { imageList.clear(); }

};


IconExtractor::IconExtractor(Application& applet, const char* name, Args& args)
	:ApplicationView(applet, name,
		args.set(XmNstyle, (ulong)WS_VSCROLL|WS_HSCROLL)),
		imageList(32, 32, ILC_MASK, 0, 5)

{
	addCallback(XmNmenuCallback, 1000, this,
			(Callback)&IconExtractor::open, NULL);
	addCallback(XmNmenuCallback, 1001, this,
			(Callback)&IconExtractor::exit, NULL);

	Args ar;
	ar.set(XmNexStyle, (ulong)WS_EX_CLIENTEDGE);
	ar.set(XmNstyle, (ulong)LVS_ICON);
	listView.create(this, "", ar);

	listView.setImageList(&imageList, LVSIL_NORMAL);

	add(listView);
	
	char dir[MAX_PATH];
	GetWindowsDirectory(dir, MAX_PATH);

	ar.reset();
	ar.set(XmNfilter, "Exe or DLL files \0*.exe;*.dll\0");
	ar.set(XmNdirectory, dir);

	fileDialog.create(this, "", ar);
}



void IconExtractor::open(Action& action)
{
	if (fileDialog.open()) {
		char title[MAX_PATH];
		char* filename = fileDialog.getFileName();

		HINSTANCE hInst = Application::getInstance();

		int num = (int)ExtractIcon(hInst, filename, -1);
		Printf("%s numIcon = %d \r\n", filename, num);
		char message[MAX_PATH];

		if (num <1) {
			sprintf(message, "No icons in the file:%s", filename);
			showMessageDialog("IconExtractor", message);
			return;

		} else {
			
			sprintf(title, "IconExtractor - %s", filename);
			setText(title);
			
			listView.clear();
			imageList.clear();

			char number[10];
			for (int i = 0; i<num; i++) {

				HICON hicon = ExtractIcon(hInst, filename, i);
				if (hicon) {
					int id  = imageList.addIcon(hicon);
					LV_ITEM item;
					memset(&item, 0, sizeof(LV_ITEM));

					item.mask = LVIF_TEXT|LVIF_IMAGE;

					item.iImage	= id;
					sprintf(number, "%d", i);
					item.pszText    = number;
					item.cchTextMax = _MAX_PATH;
					listView.insertItem(&item);
				}
			}
		}
	}
}


void	Main(int argc, char** argv)
{
	const char* appClass = "IconExtractor";
	Application applet(appClass, argc, argv);

	Args args;
	IconExtractor extractor(applet, appClass, args);
	extractor.realize();

	applet.run();
}

