/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	MainView.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\DoublyLinkedList.h>
#include <sol\ScrolledRichText.h>


class MainView :public ApplicationView {
	ScrolledRichText	text;
	void	printFromHead(const char* msg, DoublyLinkedList& list);
	void	printFromTail(const char* msg, DoublyLinkedList& list);
  public:
	MainView(Application& applet, const char* name, Args& args);
};


MainView::MainView(Application& applet, const char* name, Args& args)
	:ApplicationView(applet, name, args)
{
	Args ar;
	text.create(this, "", ar);
	add(text);

	DoublyLinkedList	list;

	list.add(new String("iaaa"));
	list.add(new String("baaa"));
	list.add(new String("paaa"));
	list.add(new String("xaaa"));
	list.add(new String("eaaa"));
	list.add(new String("oaaa"));
	list.add(new String("faaa"));
	list.add(new String("laaa"));

	printFromHead("Data", list);

	list.reverse();
	printFromTail("Reversed", list);
	
	list.sort(Sortable::DESCENDING);
	printFromHead("Sorted DESCENDING", list);

	list.sort(Sortable::ASCENDING);
	printFromHead("Sorted ASCENDING", list);
	
	list.clear();
	printFromHead("Cleared", list);
	String* one = new String("100");
	list.add(one);
	list.add(new String("342"));
	list.add(new String("890"));
	list.add(new String("235"));
	list.add(new String("555"));
	list.add(new String("124"));
	String* zero = new String("000");
	list.add(zero);
	list.add(new String("189"));
	list.add(new String("111"));
	list.add(new String("867"));

	list.sort(Sortable::ASCENDING);
	printFromTail("Sorted ", list);

	list.remove(zero);
	list.remove(one);
	printFromTail("Sorted ", list);

}

void MainView::printFromHead(const char* msg, DoublyLinkedList& list)
{
	text.printf("%s\r\nFromHead------------\r\n", msg);
	ListEntry* ptr = list.getHead();
	while (ptr) {
		String* s = (String*)ptr ->getObject();
		if (s) {
			text.printf("%s\r\n", (char*)(*s));
		}
		ptr = ptr -> getNext();
	}
	text.printf("\r\n");
}

void MainView::printFromTail(const char* msg, DoublyLinkedList& list)
{
	text.printf("%s\r\nFromTail------------\r\n", msg);
	ListEntry* ptr = list.getTail();
	while (ptr) {
		String* s = (String*)ptr ->getObject();
		if (s) {
			text.printf("%s\r\n", (char*)(*s));
		}
		ptr = ptr -> getPrev();
	}
	text.printf("\r\n");
}

// MainView Main
void	Main(int argc, char** argv)
{
	const char* appClass = "MainView";
	Application applet(appClass, argc, argv);
		
	Args args;
	MainView mainView(applet, appClass, args);
	mainView.realize();
	applet.run();
}

