/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Propdlg.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18


#include <sol\Application.h>
#include <sol\ApplicationView.h>

#include <sol\DialogView.h>
#include <sol\TextField.h>
#include <sol\PushButton.h>
#include <sol\PropertyDialog.h>


class PropertyDlg :public PropertyDialog {
	TextField		textf;
	PushButton		pushb;
	PropertyPage*    page1;
	PropertyPage*    page2;

  public:
	PropertyDlg(View* parent, const char* label, Args& args)
		:PropertyDialog(parent, label, args)
	{
		Args ar;
		ar.set(XmNtemplateName, "Font");
		page1 = new PropertyPage(this, "Font", ar);
	
		ar.reset();
		ar.set(XmNtemplateName, "Color");
		page2 = new PropertyPage(this, "Color", ar);
	}
};



class AppView :public ApplicationView {
	PropertyDlg* dlg;
	PushButton pushb;

public:
	AppView(Application& applet, const char* name, Args& args)
		:ApplicationView(applet, name, args) {
		Args ar;
		pushb.create(this, "Popup PropertyDlg", ar);
		
		ar.reset();
		dlg = new PropertyDlg(this, "Property", ar);

		pushb.addCallback(XmNactivateCallback, dlg,
			(Callback)&PropertyDialog::popup, NULL);
	}

	~AppView() {
		delete dlg;
	}	
};

void	Main(int argc, char** argv)
{
	const char* appClass = "PropertyDialog";
	Application applet(appClass, argc, argv);
	
	Args  args;
	AppView appview(applet, appClass, args);
	appview.realize();
	applet.run();
}

