/*********************************************************************

	dirtreev.h
				(C) Copyright 1997	TOSHIYUKI ARAI
				ALL RIGHTS RESERVED 
 ********************************************************************/
/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Dirtreev.h
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18


#ifndef _SOL_TREEVIEW
#include <sol\treeview.h>
#endif

#ifndef _SOL_POPUPMENU
#include <sol\PopupMenu.h>
#endif

#ifndef _SOL_DIRTREEVIEW
#define _SOL_DIRTREEVIEW

class DirTreeView :public TreeView {
	HTREEITEM homeNode;
	HTREEITEM hcurrentNode;
	PopupMenu*	popupMenu;

	void	rightClick(Action& action);

public:
	DirTreeView(View* parent, const char* name, Args& args);

	void	setPopupMenu(PopupMenu* menu) { 
		popupMenu = menu; 
	}
	char*	doubleClick(Action& action);
	void	selChanged(Action& action);

	// Add an item.
	HTREEITEM addItem(HTREEITEM parent, HTREEITEM after, 
								char* text);

	// Add an item.
	HTREEITEM addItemWithFlag(HTREEITEM parent, HTREEITEM after, 
								   char* text, BOOL readable);

	// Create directories recursively.
	void	findDirectories(HTREEITEM parent, char* dir,
				  int ini, int max);

	void	setHomeNode(HTREEITEM home) {
			homeNode = home;
	}

	HTREEITEM getHomeNode() {
		return homeNode;
	}

	// Build directories recursively.
	void	buildHierachy(HTREEITEM parent, char* dir);

	// Delete all children and siblings.
	void	deleteChildren(HTREEITEM htreeItem);


	// Expand all children.
	void	expandChildren(HTREEITEM htreeItem, DWORD flag);


	HTREEITEM getLeaf();

	// Get a hierarchy name(full path name).
	void	getHierachy(HTREEITEM selItem, 
					char* buff, char* delim);

	HTREEITEM getCurrentNode() { return hcurrentNode; }
};

#endif

