/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	SMTPClient.h
 *
 *****************************************************************************/


#include <sol\Stdio.h>

#ifndef _SOL_ARG
#include <sol\Arg.h>
#endif

#ifndef _SOL_THREAD
#include <sol\Thread.h>
#endif

#ifndef _SOL_STRING
#include <sol\String.h>
#endif

#ifndef _SOL_EXCEPTION
#include <sol\Exception.h>
#endif

#ifndef _SOL_SOCKETSTREAM
#include <sol\SocketStream.h>
#endif

#ifndef _SOL_MAIL
#include "Mail.h"
#endif

#ifndef _SOL_SMTPCLIENT
#define _SOL_SMTPCLIENT

class SMTPClient :public Thread {
	String		server;
	String		user;
	Mail&		mail;

	SocketStream*  socket;
	static Arg replyList[];
	int		result;
	String	error;

public:
	static int SERVER_READY;		// MailServer ready,
	static int QUIT_OK;				// Closing a connection
	static int COMMAND_OK;			// Command ok
	static int USER_NOT_FOUND;		// User not found, transfer ok
	static int USER_NOT_IDENTIFIED;	// UnIdentified usr
	static int DATA_OK;				// You can send a data
	static int SERVER_DOWN;			// Server down
	static int MAILBOX_BUSY;		// MailBox busy
	static int LOCAL_ERROR;			// Local error
	static int DISK_FULL;			// Disk full

	int		connect();
	int		hello(const char* message);
	int		sendFrom(const char* from);
	int		sendTo(const char* to);
	int		beginData();
	int		sendData(char* data, size_t size);
	int		endData();
	int		quit();
	Boolean recvReply(int command);
	int		sendContent(Mail& mail);

public:
	SMTPClient(const char* server1, const char* user1, Mail& mail1);
	~SMTPClient();
	int		getResult() { return result; }
	const char* getError() { return (const char*)error; }
	void	run();
};

#endif
