/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Statusbar.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\Pen.h>
#include <sol\DC.h>
#include <sol\DrawingArea.h>


class AppView :public ApplicationView {
	int		sizeArray[3];
	DrawingArea* drawingArea;
	StatusBar*   statusbar;
	long	size(Event& event);
	long	menuSelect(Event& event);
	void	draw(Action& action);
  public:
  	AppView(Application& applet, const char* name, Args& args);
	~AppView() { 
		delete drawingArea; 
		// Never delete statusbar;
	}
};


AppView::AppView(Application& applet, const char* name, Args& args)
	:ApplicationView(applet, name, args)
{
	Args ar;
	ar.set(XmNexStyle, (ulong)WS_EX_CLIENTEDGE);
	drawingArea = new DrawingArea(this, "", ar);
	drawingArea -> addCallback(XmNexposeCallback, this,
		(Callback)&AppView::draw, null);

	ar.reset();
	statusbar = new StatusBar(this, "Hello", ar);
	setStatusBar(statusbar);
	statusbar -> setParts(3, sizeArray);
	statusbar -> setText(0,  0, "Normal");
	statusbar -> setText(1, SBT_POPOUT,    "Popout");
	statusbar -> setText(2, SBT_NOBORDERS, "Noborder");

	addEventHandler(WM_MENUSELECT, this,
		(Handler)&AppView::menuSelect, NULL);
}

void AppView::draw(Action& action)
{
	DC* dc = (DC*)action.getValue();
	for(int i = 0; i<255; i++) {
		Pen* pen = new Pen(PS_INSIDEFRAME, 2, RGB(255, 255, 255-i));
		HGDIOBJ prevObj = dc -> select(pen);
		dc -> moveTo(0, i);
		dc -> lineTo(200,i);
		dc -> select(prevObj);
		delete pen;
	}
}


long AppView::size(Event& event) 
{
	ApplicationView::size(event);

	StatusBar* statusbar = getStatusBar();
	LPARAM s = event.getLParam();
	sizeArray[0] = LOWORD(s)/3;
	sizeArray[1] = LOWORD(s)*2/3;
	sizeArray[2] = -1;
	statusbar->setParts(3, sizeArray);
	RECT r;
	statusbar->getWindowRect(&r);
	drawingArea -> reshape(0, 0, LOWORD(s),  HIWORD(s)-(r.bottom-r.top));
	return 0;
}

long AppView::menuSelect(Event& event)
{
	WPARAM wParam = event.getWParam();
	HMENU  hmenu  = (HMENU)event.getLParam();
	WORD   indx = LOWORD(wParam);
	WORD   flag = HIWORD(wParam);
	if(flag & MF_HILITE) {
		char string[128];
		string[0] = Zero;
		::GetMenuString(hmenu, indx, string, sizeof(string),
				MF_BYCOMMAND);
		statusbar->setText(0, 0, string);
	}
	return 0L;
}


void	Main(int argc, char** argv)
{
	const char* name = "AppView";
	Application applet(name, argc, argv);
	Args args;
	AppView appView(applet, name, args);
	appView.realize();
	applet.run();
}

