/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Toolbar.cpp
 *
 *****************************************************************************/

// SOL++2000
// 1999.09.23 Modified 
// 2000.02.18


#include <sol\Stdio.h>
#include <sol\ApplicationView.h>
#include <sol\ToolBar.h>
#include <sol\StatusBar.h>
#include <sol\ScrolledRichText.h>


class AppView :public ApplicationView {
	ScrolledRichText* text;
	ToolBar*   toolbar;
	StatusBar* statusbar;

	long	   size(Event& event);
  public:
  	AppView(Application& applet, const char* name, Args& args);
	~AppView();
};


AppView::AppView(Application& applet, const char* name, Args& args)
	:ApplicationView(applet, name, args)
{
	Args ar;
	toolbar = new ToolBar(this, "", ar);
	setToolBar(toolbar);

	ar.reset();
	statusbar = new StatusBar(this, "Hello", ar);
	setStatusBar(statusbar);

	ar.reset();	
	text = new ScrolledRichText(this, "", ar);
}

AppView::~AppView()
{
	delete text;
}


long AppView::size(Event& event) 
{
	ApplicationView::size(event);
	
	int w, h;
	event.getSize(w, h);

	int w1, h1, w2, h2;
	toolbar   -> getSize(w1, h1);
	statusbar -> getSize(w2, h2);
	
	text -> reshape(0, h1, w, h- h1- h2);
	
	return 0L;
}


void	Main(int argc, char** argv)
{
	const char* appClass = "AppView";
	Application applet(appClass, argc, argv);

	Args args;
	AppView appView(applet, appClass, args);
	appView.realize();
	applet.run();
}
