/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	AboutDialog.h
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\TrackBar.h>
#include <sol\Static.h>
#include <sol\PaintDC.h>


class AppView :public ApplicationView {
	COLORREF  color;
	Static   item;
	TrackBar trackBar[3];
	long	drawItem(Event& event);
	long	horizScroll(Event& event);
  public:
	AppView(Application& applet, const char* label, Args& args);
};


AppView::AppView(Application& applet, const char* label, Args& args)
	:ApplicationView(applet, label, args)
{
	Args ar;
	ar.set(XmNx, 10);
	ar.set(XmNy, 10);
	ar.set(XmNwidth,  200);
	ar.set(XmNheight,  50);
	ar.set(XmNstyle, (ulong)SS_OWNERDRAW);
	item.create(this, "", ar);

	for(int i = 0; i<3; i++) {
		ar.reset();
		ar.set(XmNx, 10);
		ar.set(XmNy, 70+60*i);
		ar.set(XmNwidth, 200);
		ar.set(XmNheight, 50);
		trackBar[i].create(this, "", ar);
		trackBar[i].setRange(0, 255);
		trackBar[i].setPos(192);
	}
	color = RGB(192, 192, 192);
	addEventHandler(WM_DRAWITEM, this, 
		(Handler)&AppView::drawItem, NULL);
}


long AppView::horizScroll(Event& event)
{
	int pos[3];
	for(int i = 0; i<3; i++) {
		pos[i] = (int)trackBar[i].getPos();
	}
	color = RGB(pos[0], pos[1], pos[2]);
	
	item.update(NULL);
	return NULL;
}


long AppView::drawItem(Event& event)
{
	LPARAM lParam = event.getLParam();
	DRAWITEMSTRUCT* ptr = (DRAWITEMSTRUCT*)lParam;
	HDC hdc = ptr->hDC;
	HBRUSH hb = ::CreateSolidBrush(color);
	HBRUSH oldb = (HBRUSH)::SelectObject(hdc, hb);
	::Rectangle(hdc, 0, 0, 200, 50);
	::SelectObject(hdc, oldb);
	::DeleteObject(hb);

	return 0L;
}


void	Main(int argc, char** argv)
{
	const char* name = "TrackBar";
	Application applet(name, argc, argv);

	Args args;
	AppView appView(applet, name, args);
	appView.realize();

	applet.run();
}
