/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	TransparentButton.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\DIBitmapFile.h>
#include <sol\DIBitmap.h>
#include <sol\PaintDC.h>
#include <sol\ClientDC.h>
#include <sol\FileDialog.h>
#include <sol\TransparentButton.h>
#include "resource.h"
#include <sol\stdio.h>

class DIBitmapViewer :public ApplicationView {
	TransparentButton transb;
	DIBitmap*		bitmap;
	FileDialog		filedlg;

	long		activate(Event& event);
	long		paint(Event& event);
	void		open(Action& action);
	long		paletteChanged(Event& event);
	long		queryNewPalette(Event& event);
	void		arm(Action& action);

  public:
	DIBitmapViewer(Application& applet, const char* name, Args& args);
	~DIBitmapViewer();
};


DIBitmapViewer::DIBitmapViewer(Application& applet, const char* name, Args& args)
	:ApplicationView(applet, name,
		args.set(XmNstyle, (ulong)(WS_VSCROLL|WS_HSCROLL) ))
{
	Args ar;
	ar.set(XmNx,      20);
	ar.set(XmNy,      20);
	ar.set(XmNwidth,  50);
	ar.set(XmNheight, 50);
	ar.set(XmNstyle,  (ulong)WS_BORDER);
	ar.set(XmNcursor, (ulong)LoadCursor(NULL, IDC_CROSS));

	transb.create(this, "", ar);
	transb.addCallback(XmNarmCallback, this,
		(Callback)&DIBitmapViewer::arm, NULL);
			
	bitmap = NULL;
	addEventHandler(WM_PAINT, this,
			(Handler)&DIBitmapViewer::paint, NULL);
	addCallback(XmNmenuCallback, ID_OPEN, this,
			(Callback)&DIBitmapViewer::open, NULL);
	addCallback(XmNmenuCallback, ID_EXIT, this,
			(Callback)&DIBitmapViewer::exit, NULL);

	addEventHandler(WM_PALETTECHANGED, this,
			(Handler)&DIBitmapViewer::paletteChanged, NULL);

	addEventHandler(WM_QUERYNEWPALETTE, this,
			(Handler)&DIBitmapViewer::queryNewPalette, NULL);

 	static char dir[128];
	::GetWindowsDirectory(dir, 128);


	ar.reset();
	ar.set(XmNdirectory, dir);
	ar.set(XmNfilter, "Bitmap (*.bmp)\0 *.bmp\0");
	filedlg.create(this, NULL, ar);
}


DIBitmapViewer::~DIBitmapViewer()
{
	if(bitmap) delete bitmap;
}


void DIBitmapViewer::arm(Action& action)
{
	Printf("DIBitmapViewer::Arm called \r\n");
}


long DIBitmapViewer::activate(Event& event)
{
	WORD flag =	LOWORD(event.getWParam());

	if(flag) {
		return queryNewPalette(event);
	}
	return 0L;
}


long DIBitmapViewer::paletteChanged(Event& event)
{
	HWND hwnd =	(HWND)event.getWParam();
	if(hwnd != getWindow()) {
		return queryNewPalette(event);
	}
	return 0L;
}


long DIBitmapViewer::queryNewPalette(Event& event)
{
	ClientDC cdc(this);
	if(bitmap) {
		Palette* pal = bitmap -> getPalette();
		if(pal) {
			HPALETTE hpal = cdc.select(pal, FALSE);
			int num = cdc.realizePalette();
			cdc.select(hpal, FALSE);
			cdc.realizePalette();
			if(num >0) {
	   			update();
			}
		}
	}
	return 0L;
}


void DIBitmapViewer::open(Action& action)
{
	if(filedlg.open() == IDOK) {
		char* filename = filedlg.getFileName();
		char title[256];

		DIBitmapFile file;
		if(file.openReadOnly(filename) >= 0) {
			DIBitmap* tbitmap = file.extract();
			file.close();
	    	if(tbitmap) {
				if(bitmap) delete bitmap;
				bitmap = tbitmap;
				sprintf(title, "DIBitmapViewer : %s", filename);
				setText(title);
				setScrollPos(HORIZONTAL, 0);
				setScrollPos(VERTICAL, 0);
				queryNewPalette(action.getEvent());
		
				update(NULL);
			}
		}
	}
}


long DIBitmapViewer::paint(Event& event)
{
	PaintDC pdc(this);

	if(bitmap) {
		int x = getScrollPos(HORIZONTAL);
		int y = getScrollPos(VERTICAL);
		bitmap -> setSource(x, y);
		bitmap -> draw(pdc, 0, 0);
	}
	return 0L;
}



void	Main(int argc, char** argv)
{
	const char* appClass = "DIBitmapViewer";
	Application applet(appClass, argc, argv);

	Args args;
	args.set(XmNhorizScrollMaximum, 300);
	args.set(XmNvertScrollMaximum,  300);
	DIBitmapViewer bitmapView(applet, appClass, args);
	bitmapView.realize();

	applet.run();
}

