/******************************************************************************
 *
 * Copyright (c) 2000	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	SpecialFolder.h
 *
 *****************************************************************************/

// SOL++2000
// 2000.07.06

#ifndef _SOL_OBJECT
#include <sol\Object.h>
#endif

#include <shlobj.H>

#ifndef _SOL_SPECIALFOLDER
#define _SOL_SPECIALFOLDER

class SpecialFolder :public Object {

public:
	SpecialFolder() { }

	HRESULT	getALTStartup(char* path, HWND owner = NULL, BOOL flag=FALSE) {
		return ::SHGetSpecialFolderPath(owner, path, CSIDL_ALTSTARTUP, flag);
	}

	HRESULT	getAppData(char* path, HWND owner = NULL, BOOL flag=FALSE) {
		return ::SHGetSpecialFolderPath(owner, path, CSIDL_APPDATA, flag);
	}

	HRESULT	getBitBucket(char* path, HWND owner = NULL, BOOL flag=FALSE) {
		return ::SHGetSpecialFolderPath(owner, path, CSIDL_BITBUCKET, flag);
	}

	HRESULT	getCommonALTStartup(char* path, HWND owner = NULL, BOOL flag=FALSE) {
		return ::SHGetSpecialFolderPath(owner, path, CSIDL_COMMON_ALTSTARTUP, flag);
	}

	HRESULT	getCommonDesktopDirectory(char* path, HWND owner = NULL, BOOL flag=FALSE) {
		return ::SHGetSpecialFolderPath(owner, path, CSIDL_COMMON_DESKTOPDIRECTORY, flag);
	}

	HRESULT	getCommonFavorites(char* path, HWND owner = NULL, BOOL flag=FALSE) {
		return ::SHGetSpecialFolderPath(owner, path, CSIDL_COMMON_FAVORITES, flag);
	}

	HRESULT	getCommonPrograms(char* path, HWND owner = NULL, BOOL flag=FALSE) {
		return ::SHGetSpecialFolderPath(owner, path, CSIDL_COMMON_PROGRAMS, flag);
	}

	HRESULT	getCommonStartMenu(char* path, HWND owner = NULL, BOOL flag=FALSE) {
		return ::SHGetSpecialFolderPath(owner, path, CSIDL_COMMON_STARTMENU, flag);
	}

	HRESULT	getCommonStartup(char* path, HWND owner = NULL, BOOL flag=FALSE) {
		return ::SHGetSpecialFolderPath(owner, path, CSIDL_COMMON_STARTUP, flag);
	}

	HRESULT	getCookies(char* path, HWND owner = NULL, BOOL flag=FALSE) {
		return ::SHGetSpecialFolderPath(owner, path, CSIDL_COOKIES, flag);
	}

	HRESULT	getDesktopDirectory(char* path, HWND owner = NULL, BOOL flag=FALSE) {
		return ::SHGetSpecialFolderPath(owner, path, CSIDL_DESKTOPDIRECTORY, flag);
	}

	HRESULT	getFavorites(char* path, HWND owner = NULL, BOOL flag=FALSE) {
		return ::SHGetSpecialFolderPath(owner, path, CSIDL_FAVORITES, flag);
	}

	HRESULT	getHistory(char* path, HWND owner = NULL, BOOL flag=FALSE) {
		return ::SHGetSpecialFolderPath(owner, path, CSIDL_HISTORY, flag);
	}
	HRESULT	getInternetCache(char* path, HWND owner = NULL, BOOL flag=FALSE) {
		return ::SHGetSpecialFolderPath(owner, path, CSIDL_INTERNET_CACHE, flag);
	}

	HRESULT	getNetHood(char* path, HWND owner = NULL, BOOL flag=FALSE) {
		return ::SHGetSpecialFolderPath(owner, path, CSIDL_NETHOOD, flag);
	}

	HRESULT	getPersonal(char* path, HWND owner = NULL, BOOL flag=FALSE) {
		return ::SHGetSpecialFolderPath(owner, path, CSIDL_PERSONAL, flag);
	}

	HRESULT	getPrintHood(char* path, HWND owner = NULL, BOOL flag=FALSE) {
		return ::SHGetSpecialFolderPath(owner, path, CSIDL_PRINTHOOD, flag);
	}

	HRESULT	getPrograms(char* path, HWND owner = NULL, BOOL flag=FALSE) {
		return ::SHGetSpecialFolderPath(owner, path, CSIDL_PROGRAMS, flag);
	}

	HRESULT	getRecent(char* path, HWND owner = NULL, BOOL flag=FALSE) {
		return ::SHGetSpecialFolderPath(owner, path, CSIDL_RECENT, flag);
	}

	HRESULT	getSendTo(char* path, HWND owner = NULL, BOOL flag=FALSE) {
		return ::SHGetSpecialFolderPath(owner, path, CSIDL_SENDTO, flag);
	}

	HRESULT	getStartMenu(char* path, HWND owner = NULL, BOOL flag=FALSE) {
		return ::SHGetSpecialFolderPath(owner, path, CSIDL_STARTMENU, flag);
	}

	HRESULT	getStartup(char* path, HWND owner = NULL, BOOL flag=FALSE) {
		return ::SHGetSpecialFolderPath(owner, path, CSIDL_STARTUP, flag);
	}

	HRESULT	getTemplates(char* path, HWND owner = NULL, BOOL flag=FALSE) {
		return ::SHGetSpecialFolderPath(owner, path, CSIDL_TEMPLATES, flag);
	}
};

#endif


