/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	String.h
 *
 *****************************************************************************/

// SOL++2000
// 1999.09.03 Added a constructor to take a pointer to String.
// 2000/11/11


#ifndef _SOL_OBJECT
#include <sol\Object.h>
#endif

#ifndef _SOL_STRING
#define _SOL_STRING

class String :public Object {
    int		len;
    char*	text;
    BOOL	copy(const char* string);

  public:
	String(const char* string = "");
	// 1999.09.03
	String(const String* string);

	String(const String& string);
	~String() { delete [] text; }
	const char*	find(const char* string);

	char*   getContents() const { return text; }
	int     getLength() const  { return len; }

	String& operator=(const char* string);		
	String& operator=(const String& string);
 	String& operator+(const char* string);
	

	int     operator==(const char* string);
	int		operator==(String& string);
	operator char*() { return text; }
	operator const char*() { return text; }
	char&    operator[](int n);

	int		compare(Object* object);
	// 1999.08.07
	int		replace(char oc, char  nc);

	//<added date="2000/11/10">
	String& operator+(int num);
	String& operator+(float num);
	String& operator+(char ch);
	void	trim();
	Boolean startsWith(const char* string);
	Boolean endsWith(const char* string);
	const char* findLast(const char* string);
	Boolean	equalsIgnoreCase(const char* string);
	Boolean	equalsIgnoreCase(String& string);

	//</added>
};

#endif
