/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Window.h
 *
 *****************************************************************************/

// SOL++2000

#ifndef _SOL_OBJECT
#include <sol\Object.h>
#endif

#ifndef _SOL_TYPEDEF
#include <sol\Typedef.h>
#endif

#ifndef _SOL_WINDOW
#define _SOL_WINDOW


class Window :public Object {
	HWND		hwnd;

  public:
	Window();
	~Window();

	HWND	childWindowFromPoint(POINT pt) {
			return ::ChildWindowFromPoint(hwnd, pt);
	}

	void	destroyWindow() {
			if (isWindow())
			::DestroyWindow(hwnd);
	}

	Boolean	isEqual(HWND handle) {
			return (hwnd == handle);
	}
	void	enableWindow(Boolean flag) {
			::EnableWindow(hwnd, flag);
	}
	void	getClassName(char* name, int size) {
			::GetClassName(hwnd, name, size);
	}

	HWND	getFocus() {
			return ::GetFocus();
	}

	HINSTANCE	getInstanceHandle() {
			return (HINSTANCE)getWindowLong(GWL_HINSTANCE);
	}

	Boolean	getPlacement(WINDOWPLACEMENT* place) {
			return ::GetWindowPlacement(hwnd, place);
	}

	HANDLE	getProp(const char* name) {
			return ::GetProp(hwnd, name);
	}

	HWND	getWindow() { return hwnd; }

	long	getWindowLong(int indx) {
			return ::GetWindowLong(hwnd, indx);
	}
	WORD	getWindowWord(int indx) {
			return ::GetWindowWord(hwnd, indx);
	}
 	long	getClassLong(int indx) {
			return ::GetClassLong(hwnd, indx);
	}
 	WORD	getClassWord(int indx) {
			return ::GetClassWord(hwnd, indx);
	}

	virtual void getClientRect(RECT* rect) {
			::GetClientRect(hwnd, rect);
	}
	void	getWindowRect(RECT* rect) {
			::GetWindowRect(hwnd, rect);
	}

	Boolean	isEnabled() {
			return ::IsWindowEnabled(hwnd);
	}
	Boolean	isVisible() {
			return ::IsWindowVisible(hwnd);
	}
	Boolean	isWindow()  {
			return ::IsWindow(hwnd);
	}
	Boolean	killTimer(UINT id) {
			return ::KillTimer(hwnd, id);
	}

	void	move(int x, int y, int width, int height, Boolean flag = TRUE) {
			::MoveWindow(hwnd, x, y, width, height, flag);
	}

	virtual void	reshape(int x, int y, int width, int height, Boolean flag = TRUE) {
			::MoveWindow(hwnd, x, y, width, height, flag);
	}

	char*   getText();

	int		getText(char* text, int len) {
			return ::GetWindowText(hwnd, text, len);
	}
	int		getTextLength() {
			return ::GetWindowTextLength(hwnd);
	}
	void	getCursorPos(POINT* p) {
			::GetCursorPos(p);
	}

	Boolean	invalidate(const RECT* rect, Boolean flag = TRUE) {
			return ::InvalidateRect(hwnd, rect, flag);
	}

	Boolean	invalidate(HRGN r, Boolean flag = TRUE) {
			return ::InvalidateRgn(hwnd, r, flag);
	}

	long	post(UINT message, WPARAM wParam, LPARAM lParam) {
			return ::PostMessage(hwnd, message, wParam, lParam);
	}

	HANDLE	removeProp(const char* name) {
			return ::RemoveProp(hwnd, name);
	}

	Boolean	releaseCapture() {
			return ::ReleaseCapture();
	}
	int		showCursor(Boolean flag) {
			return ::ShowCursor(flag);
	}

	Boolean	scroll(int dx, int dy, RECT* scroll, RECT* clip,
				HRGN  hrgnUpdate=NULL,LPRECT  prcUpdate=NULL,
			UINT flags = SW_ERASE|SW_INVALIDATE|SW_SCROLLCHILDREN) {
			return ::ScrollWindowEx(hwnd, dx, dy, scroll, clip,
					hrgnUpdate, prcUpdate, flags);
	}

	long	send(UINT message, WPARAM wParam, LPARAM lParam) {
			return ::SendMessage(hwnd, message, wParam, lParam);
	}
	void	setClassLong(int indx, long val) {
			::SetClassLong(hwnd, indx, val);
	}
	void	setClassWord(int indx, WORD val) {
			::SetClassWord(hwnd, indx, val);
	}
	HWND	setFocus(HWND target) {
			return ::SetFocus(target);
	}

	HWND	setFocus() {
			return ::SetFocus(hwnd);
	}

	void	setParent(HWND hParent) {
				::SetParent(hwnd, hParent);
	}
	Boolean	setPlacement(WINDOWPLACEMENT* place) {
			return ::SetWindowPlacement(hwnd, place);
	}
	Boolean	setPos(HWND insertAfter, int x, int y, int width,
				int height, UINT flag) {
			return ::SetWindowPos(hwnd, insertAfter, x, y,
				width, height, flag);
	}
	Boolean	setProp(const char* name, HANDLE data) {
			return ::SetProp(hwnd, name, data);
	}
	void	setText(const char* text) {
			::SetWindowText(hwnd, text);
	}
	UINT	setTimer(UINT id, UINT elapse, TIMERPROC proc) {
			return ::SetTimer(hwnd, id, elapse, proc);
	}

	void	setWindow(HWND hwnd1) {
			hwnd = hwnd1;
	}

	void	capture() {
			::SetCapture(hwnd);
	}

	Boolean	setForegroundWindow() {
			return ::SetForegroundWindow(hwnd);
	}

	void	setWindowLong(int indx, LONG val) {
			::SetWindowLong(hwnd, indx, val);
	}
	void	setWindowWord(int indx, WORD val) {
			::SetWindowWord(hwnd, indx, val);
	}
	void	show(int cmd) {
			::ShowWindow(hwnd, cmd);
	}
	void	toClient(POINT* pt) {
			::ScreenToClient(hwnd, pt);
	}
	void	toScreen(POINT* pt) {
			::ClientToScreen(hwnd, pt);
	}
	void	update() {
			::UpdateWindow(hwnd);
	}
	void	update(const RECT* r) {
			invalidate(r);
			::UpdateWindow(hwnd);
	}

	Boolean	flash(Boolean invert) {
			return ::FlashWindow(hwnd, invert);			
	}

	HWND	getLastActivePopup() {
			return ::GetLastActivePopup(hwnd);
	}

	HWND	getTopWindow() {
			return ::GetTopWindow(hwnd);
	}
	DWORD	getThreadProcessId(DWORD* processId) {
			return ::GetWindowThreadProcessId(hwnd, processId);
	}

	Boolean	redraw(const RECT* rect, HRGN rgn, UINT flags) {
			return ::RedrawWindow(hwnd, rect, rgn, flags);
	}

	Boolean	validate(const RECT* r) {
			return ::ValidateRect(hwnd, r);
	}
	Boolean	validate(HRGN  r) {
			return ::ValidateRgn(hwnd, r);
	}

	Boolean	send(UINT message, WPARAM wParam, LPARAM lParam,
					SENDASYNCPROC callback, DWORD data) {
			return ::SendMessageCallback(hwnd, message,
					wParam, lParam,  callback, data);
	}
	long	send(UINT message, WPARAM wParam, LPARAM lParam,
					UINT flags, UINT timeOut, DWORD* result) {
			return ::SendMessageTimeout(hwnd, message,
					wParam, lParam, flags, timeOut, result);
	}
	long	sendNotify(UINT message, WPARAM wParam, LPARAM lParam) {
			return ::SendNotifyMessage(hwnd, message,
					wParam, lParam);
	}
	Boolean	showAsync(int cmd) {
			return ::ShowWindowAsync(hwnd, cmd);
	}
	Boolean	hideOwnedPopups() {
			return ::ShowOwnedPopups(hwnd, FALSE);
	}
	Boolean	showOwnedPopups() {
			return ::ShowOwnedPopups(hwnd, TRUE);
	}
};

#endif

