/******************************************************************************
 *
 * Copyright (c) 2001	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	DialogView.cpp
 *
 *****************************************************************************/


#include <sol\ApplicationView.h>
#include <sol\BorderLayout.h>
#include <sol\ScrolledText.h>
#include <sol\PushButton.h>
#include <sol\DialogView.h>

class MessageDialog :public DialogView {
    BorderLayout layout;
    Text         message;
    PushButton   ok;

  public:
    Boolean create(View* parent, const char* title, Args& args)
    {
		DialogView::create(parent, title, args);

		setLayout(&layout);
        Args ar;
        ar.set(XmNstyle, (ulong)ES_MULTILINE);
        message.create(this, "", ar);
        add(message, BorderLayout::CENTER);

        ar.reset();
        ok.create(this, "Popdown", ar);
        add(ok, BorderLayout::SOUTH);
                
        resize();
        //Register callback to ok button to pop down this window.
        ok.addCallback(XmNactivateCallback, this, 
			(Callback)&MessageDialog::popdown, null);
        return True;
    }

    void setMessage(const char* text) {
        message.setText(text);
    }
};


class MainView :public ApplicationView {
    PushButton    popupb;
    MessageDialog  message;

  public:
    // Constructor
    MainView(Application& applet, const char* name, Args& args)
        :ApplicationView(applet, name, args) 
    {
        Args ar;
        popupb.create(this, "Popup a MessageDialog", ar);
        add(popupb);

        ar.reset();
        ar.set(XmNx, 100);
        ar.set(XmNy, 100);
        ar.set(XmNwidth,  300);
        ar.set(XmNheight, 200);
        message.create(this, "MessageDialog", ar);
        message.setMessage("Hello.\r\nThis is a DialogView");

        // Register popup callback of PopupView class to the popupb.
        popupb.addCallback(XmNactivateCallback, &message, 
            (Callback)&PopupView::popupAsItIs, NULL);
    }
};

// Program Entry Point.
void    Main(int argc, char** argv)
{
    const char* name = "DialogView";
    // Create an instance of Application.
    Application applet(name, argc, argv);

    Args args;
    // Create an instance of HelloWorld.
    MainView mainv(applet, name, args);

    // Realize or show the buttonSample.
    mainv.realize();

    // Enter SOL++ event handling loop.
    applet.run();
}
