/******************************************************************************
 *
 * Copyright (c) 2001	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	HelloWorld.cpp
 *
 *****************************************************************************/


#include <sol\ApplicationView.h>
#include <sol\PaintDC.h>


// Inherit ApplicationView which is a SOL++ TopLevelWindow class. 
class HelloWorld :public ApplicationView {

    // EventHandler for WM_PAINT message!
    long paint(Event& event) {
        PaintDC pdc(this);
        char* text = "Hello World";
        pdc.textOut(10, 10, text, strlen(text));
        return 0L;
    }
        
  public:
    // Constructor
    HelloWorld(Application& applet, const char* name, Args& args)
        :ApplicationView(applet, name, args) 
    {
        // Add an event handler paint to this class
        // to handle a WM_PAINT event. 
        addEventHandler(WM_PAINT, this, (Handler)&HelloWorld::paint, null); 
    }   
};

// Program Entry Point.
void    Main(int argc, char** argv)
{
    const char* name = "HelloWorld";
    // Create an instance of Application.
    Application applet(name, argc, argv);

    Args args;
    // Create an instance of HelloWorld.
    HelloWorld helloWorld(applet, name, args);

    // Realize or show the helloWorld.
    helloWorld.realize();

    // Enter SOL++ event handling loop.
    applet.run();
}

