/******************************************************************************
 *
 * Copyright (c) 2001	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Hotkey.cpp
 *
 *****************************************************************************/


#include <sol\ApplicationView.h>
#include <sol\HotKey.h>

class MainView :public ApplicationView {
    HotKey  hotkey;
    WORD    keyComb;

    // Event handler for WM_SYSCOMMAND event.
    // If this event is caused by the keyComb combination, iconify this window.
    long    sysCommand(Event& event) {
        if(event.getWParam() == SC_HOTKEY) {
            show(SW_MINIMIZE);
            return NULL;
        }
        else {
            return defaultProc(event);
        }
    }

  public:
    // Constructor
    MainView(Application& applet, const char* name, Args& args)
        :ApplicationView(applet, name, args) 
    {
        Args ar;   
        // Create a window of HotKey
        ar.set(XmNwidth,  100);
        ar.set(XmNheight, 30);
        ar.set(XmNexStyle, (ulong)WS_EX_WINDOWEDGE);
        hotkey.create(this, "", ar);
        hotkey.setHotKey('X', HOTKEYF_CONTROL);

        keyComb =   MAKEWORD('X', HOTKEYF_CONTROL);
        // Set the key combination keyComb to this Window.   
        this -> send(WM_SETHOTKEY, keyComb, 0);
        // Register an event handler for WM_SYSCOMMAND.
        addEventHandler(WM_SYSCOMMAND, this, (Handler)&MainView::sysCommand, NULL);
    }
};


// Program Entry Point.
void    Main(int argc, char** argv)
{
    const char* name = "MainView";
    // Create an instance of Application.
    Application applet(name, argc, argv);

    Args args;
    // Create an instance of HelloWorld.
    MainView mainv(applet, name, args);

    // Realize or show the buttonSample.
    mainv.realize();

    // Enter SOL++ event handling loop.
    applet.run();
}
