/******************************************************************************
 *
 * Copyright (c) 2001	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	HttpClient.cpp
 *
 *****************************************************************************/


#include <sol\ApplicationView.h>
#include <sol\ScrolledRichText.h>
#include <sol\SocketStream.h>
#include <sol\Stdio.h>
#include <sol\Thread.h>


class HttpThread :public Thread {
	ScrolledRichText& richText;
	String			  host;

public:
	// Constructor
	HttpThread(ScrolledRichText& text, const char* ahost)
		:richText(text),
		host(ahost) {
	}

	// Thread procedure
	void run() {

		//1 Create an instance of SocketStream. 
		SocketStream socket(AF_INET, 0);
 
		//2 Create an instance of InetAddress by specifying host name
		//and port number.
		InetAddress address((const char*)host,  80);

		//3 Call a connect method of Socket to connect to the host.
		socket.connect(address);

		//4 Send a request data to the host.	
		socket.printf("GET /index.html HTTP/1.0\r\n\r\n");

		//5 Receive a response data from the host.
		int size = 0;
		char buffer[1024];
		while ( (size = socket.recv(buffer, sizeof(buffer)-1, 0)) >0) {
			buffer[size]= Zero;
			richText.append(buffer);
		}
		// 6 Close the socket.
		socket.close();
	}
};


class HttpClient :public ApplicationView {
    ScrolledRichText  richText;
	HttpThread*       thread;

  public:
     HttpClient(Application& applet, const char* caption, Args& args)
        :ApplicationView(applet, caption, args) {

        Args ar;
        richText.create(this, "", ar);
		add(richText);
	
		thread = new HttpThread(richText, "localhost");
		thread->start();
	 }

	 ~HttpClient() {
		delete thread;
	 }
};

void Main(int argc, char** argv)
{
     static const char* appClass = "HttpClient";
    Application applet(appClass, argc, argv);

     Args args;
     args.set(XmNclassName, appClass);

     HttpClient client(applet, appClass, args);
     client.realize();
     applet.run(); 
}


