/******************************************************************************
 *
 * Copyright (c) 2001	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ModelessDialog.cpp
 *
 *****************************************************************************/


#include <sol\ApplicationView.h>
#include <sol\ModelessDialog.h>
#include <sol\PushButton.h>
#include <sol\TextField.h>

#include "resource.h"


//Define a subclass which inherits ModelessDialog.
class FileNameDialog :public ModelessDialog {
    PushButton* ok;
    TextField*  name;

    void    doclose(Action& action) {
        // Do something here when ok is clicked.
    }

  public:
    FileNameDialog(View* parent, const char* title, Args& args)
        :ModelessDialog(parent, title, args.set(XmNtemplateName, "FileName"))
    {
        //Here, you can create instances from dialog template
        // in ModelessDialog. 
        ok   = new PushButton(this, getItem(IDOK));
        name = new TextField(this, getItem(IDC_EDIT));
        ok -> addCallback(XmNactivateCallback, this, 
			(Callback)&FileNameDialog::doclose, null);

        //Register doclose callback to a button of IDOK.
        addCallback(XmNactivateCallback, IDOK, this, 
			(Callback)&FileNameDialog::doclose, null);
    }
    
    ~FileNameDialog() {
        delete ok;
        delete name;
    }
};


class MainView :public ApplicationView {
    PushButton      popupb;
    FileNameDialog*  dialog;

  public:
    // Constructor
    MainView(Application& applet, const char* name, Args& args)
        :ApplicationView(applet, name, args) 
    {
        Args ar;
        popupb.create(this, "Popup a ModelessDialog", ar);
        add(popupb);

        ar.reset();
        dialog = new FileNameDialog(this, "Dialog", ar);

        // Register popup callback of PopupView class to the popupb.
        popupb.addCallback(XmNactivateCallback, dialog, 
                    (Callback)&PopupView::popup, NULL);
    }

    ~MainView() { delete dialog; }
};


// Program Entry Point.
void    Main(int argc, char** argv)
{
    const char* name = "ModelessDialog";
    // Create an instance of Application.
    Application applet(name, argc, argv);

    Args args;
    // Create an instance of HelloWorld.
    MainView mainv(applet, name, args);

    // Realize or show the buttonSample.
    mainv.realize();

    // Enter SOL++ event handling loop.
    applet.run();
}
