/******************************************************************************
 *
 * Copyright (c) 2001	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	PushButton.cpp
 *
 *****************************************************************************/


#include <sol\ApplicationView.h>
#include <sol\PushButton.h>

class MainView :public ApplicationView {
    PushButton* ok;
    // Callback function.
    // This is called automatically by clicking ok button. 
    void  accept(Action& action) {
        // Do something here.
    }

  public:
    // Constructor
    MainView(Application& applet, const char* title, Args& args)
        :ApplicationView(applet, title, args)
    {
        Args ar;
        // Create an instance of PushButton
        ar.set(XmNx, 10);
        ar.set(XmNy, 10);
        ok = new PushButton(this, "OK", ar);
        
        // Register a callback function accept to the ok button.
        ok->addCallback(XmNactivateCallback, this,
                (Callback)&MainView::accept, null);
    }
   
    ~MainView() 
    {
        delete ok;
    }
 };


// Program Entry Point.
void    Main(int argc, char** argv)
{
    const char* name = "MainView";
    // Create an instance of Application.
    Application applet(name, argc, argv);

    Args args;
    // Create an instance of MainView.
    MainView mainv(applet, name, args);

    // Realize or show the helloWorld.
    mainv.realize();

    // Enter SOL++ event handling loop.
    applet.run();
}

