/******************************************************************************
 *
 * Copyright (c) 2001	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	HttpClient.cpp
 *
 *****************************************************************************/


#include <sol\ApplicationView.h>
#include <sol\PaintDC.h>
#include <sol\Pen.h>

class MainView :public ApplicationView {

    // Eventhandler to handle WM_PAINT event.
    long    paint(Event& event)
    {
        //Create an instance of PaintDC.
        PaintDC pdc(this);
        RECT    r;
        getClientRect(&r);
        int w = r.bottom/255+1;
        for(int i = 0; i < 255; i++) {
            Pen pen(PS_INSIDEFRAME, w+2, RGB(255, 255, 255-i) );
            //Select the pen for PaintDC.
            HGDIOBJ prev = pdc.select(&pen);
                
            //Draw a line.
            pdc.moveTo(0, w*i, null);
            pdc.lineTo(r.right, w*i);

            //Select the previous pen to deselect the pen instance.
            pdc.select(prev);
        }
        return 0L;
    }

  public:
    MainView(Application& applet, const char* label, Args& args)
        :ApplicationView(applet, label, args)
    {
        // Register paint method of this class for the WM_PAINT event.
        addEventHandler(WM_PAINT, this, (Handler)&MainView::paint, null);
    }
};

// Program Entry Point.
void    Main(int argc, char** argv)
{
    const char* name = "Pen";
    // Create an instance of Application.
    Application applet(name, argc, argv);

    Args args;
    // Create an instance of HelloWorld.
    MainView mainv(applet, name, args);

    // Realize or show the buttonSample.
    mainv.realize();

    // Enter SOL++ event handling loop.
    applet.run();
}


