/******************************************************************************
 *
 * Copyright (c) 2001	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	PushButton.cpp
 *
 *****************************************************************************/


#include <sol\ApplicationView.h>
#include <sol\PushButton.h>

// Inherit ApplicationView which is a SOL++ TopLevelWindow class. 
class ButtonSample :public ApplicationView {
    PushButton pushb;
    
    // Callback function to handle WM_COMMAND message.
    void  quit(Action& action) {
            // Call exit method of View to terminate this program. 
            exit(action);
    }

  public:
    // Constructor
    ButtonSample(Application& applet, const char* name, Args& args)
        :ApplicationView(applet, name, args) 
    {
        Args ar;
        // Create an instance of PushButton
		ar.set(XmNx, 40);
		ar.set(XmNy, 20);
        pushb.create(this, "Quit", ar);
        
        // Register the method quit of this class to the pushb.
        // SOL++2000 frame work will call automatically the registered method
        // quit to the pushb whenever it is pushed! 
        pushb.addCallback(XmNactivateCallback, this, 
			(Callback)&ButtonSample::quit, null); 
    }
};

// Program Entry Point.
void    Main(int argc, char** argv)
{
    const char* name = "ButtonSample";
    // Create an instance of Applcation.
    Application applet(name, argc, argv);

    Args args;
    // Create an instance of HelloWorld.
    ButtonSample buttonSample(applet, name, args);

    // Realize or show the buttonSample.
    buttonSample.realize();

    // Enter SOL++ event handling loop.
    applet.run();
}

