/******************************************************************************
 *
 * Copyright (c) 2001	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ReplaceDialog.cpp
 *
 *****************************************************************************/


#include <sol\ApplicationView.h>
#include <sol\ScrolledText.h>
#include <sol\ReplaceDialog.h>

#include "resource.h"

class MainView :public ApplicationView {
    UINT            findMsg;
    ScrolledText   text;
    ReplaceDialog  replaceDialog;
    //Eventhandler for the findMsg Event.
    long    search(Event& event) {
        Args ar;
        char* find = null;
        char* replace = null;
        ulong  flags;
        ar.set(XmNflags, (void*)&flags);
        ar.set(XmNfindString, (char**)&find);
        ar.set(XmNreplaceString, (char**)&replace);
        replaceDialog.getValues(ar);

        if (flags & FR_DIALOGTERM) { 
            // cancel
            return 0L;
        }
        if (flags & FR_FINDNEXT) { 
            // find next
        }
        if (flags & FR_REPLACE) { 
            // replace and find next
        }
        if (flags & FR_REPLACEALL) { 
            // replace all
        }
        return 0L;
    }

    //Menu callback to popup the replaceDialog.
    void    replace(Action& action) {
        if(!replaceDialog.isWindow()) {
            // Popup the replaceDialog
            replaceDialog.replace("", "");
        }
    }

  public:
    //Constructor
    MainView(Application& applet, const char* name, Args& args)
        :ApplicationView(applet, name, args)
    {
        Args ar;
        ar.set(XmNnoHideSel, True);
        text.create(this, "", ar);
        add(text);

        //Register a message of FINDMSSGSTRING.
        findMsg = RegisterWindowMessage(FINDMSGSTRING);

        ar.reset();
        replaceDialog.create(this, "", ar);
        //Register replace callback to popup the replaceDialog.
        addCallback(XmNmenuCallback, ID_REPLACE, this, (Callback)&MainView::replace, null);

        //Register search eventhandler to start a find-replace operation.      
        addEventHandler(findMsg, this, (Handler)&MainView::search, null);
    }
};

// Program Entry Point.
void    Main(int argc, char** argv)
{
    const char* name = "MainView";
    // Create an instance of Application.
    Application applet(name, argc, argv);

    Args args;
    // Create an instance of HelloWorld.
    MainView mainv(applet, name, args);

    // Realize or show the buttonSample.
    mainv.realize();

    // Enter SOL++ event handling loop.
    applet.run();
}

