/******************************************************************************
 *
 * Copyright (c) 2001	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ScrollBar.cpp
 *
 *****************************************************************************/


#include <sol\ApplicationView.h>
#include <sol\ScrollBar.h>

class MainView :public ApplicationView {
    ScrollBar scrollbar;
    
    // Callback function to handle Windows WM_HSCROLL event. 
    void  horizScroll(Action& action) {
          // Do something when the scrollbar scrolled.
          // Get a thumb position by calling a getPos method. 
          int pos = scrollbar.getPos(); 
    }
  
  public:
    // Constructor
    MainView(Application& applet, const char* name, Args& args)
        :ApplicationView(applet, name, args)
    {
        Args ar;
		ar.set(XmNx, 10);
		ar.set(XmNy, 10);
        ar.set(XmNwidth,  200);
        ar.set(XmNheight, 20);
        ar.set(XmNminimum,   0);
        ar.set(XmNmaximum, 255);
        ar.set(XmNstyle,   ScrollBar::HORIZONTAL);
        // Create a window of ScrollBar
        scrollbar.create(this, "", ar);
        
        // Register the method horizScroll of this class 
        //to the scrollbar.
        // SOL++2000 frame work will call automatically the registered method
        // horizScroll to the scrollbar whenever it is manipulated! 
        scrollbar.addCallback(XmNhorizScrollCallback, this, 
                                 (Callback)&MainView::horizScroll, null); 
    }
};

// Program Entry Point.
void    Main(int argc, char** argv)
{
    const char* name = "MainView";
    // Create an instance of Application.
    Application applet(name, argc, argv);

    Args args;
    // Create an instance of HelloWorld.
    MainView mainv(applet, name, args);

    // Realize or show the buttonSample.
    mainv.realize();

    // Enter SOL++ event handling loop.
    applet.run();
}
