/******************************************************************************
 *
 * Copyright (c) 2001	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	StatusBar.cpp
 *
 *****************************************************************************/


#include <sol\ApplicationView.h>

class MainView :public ApplicationView {
    int          sizeArray[3];
    StatusBar*   statusbar;

    // Override size method of Composite class to fix the size of 
    // each part of the statusbar.
    long    size(Event& event) {
        ApplicationView::size(event);
        LPARAM s = event.getLParam();
        // Set the size of parts of the statusbar.
        sizeArray[0] = LOWORD(s)/3;
        sizeArray[1] = LOWORD(s)*2/3;
        sizeArray[2] = -1;
        statusbar->setParts(3, sizeArray);
        return 0L;      
    }

  public:
    // Constructor
    MainView(Application& applet, const char* name, Args& args)
        :ApplicationView(applet, name, args) 
    {
        Args ar;
        // Create an instance of StatusBar.
        statusbar = new StatusBar(this, "Hello", ar);
        // Set the statusbar to this Window.
        // You never delete the statusbar after calling setStatusBar method.
        setStatusBar(statusbar);
        statusbar -> setParts(3, sizeArray);
        statusbar -> setText(0,  0, "Normal");
        statusbar -> setText(1, SBT_POPOUT,    "Popout");
        statusbar -> setText(2, SBT_NOBORDERS, "Noborder");
    }
    ~MainView() {
       // Never delete the statusbar, because it will be deleted automatically
       // in the destructor of ApplicationView.
    }
};

 


// Program Entry Point.
void    Main(int argc, char** argv)
{
    const char* name = "StatusBar";
    // Create an instance of Application.
    Application applet(name, argc, argv);

    Args args;
    // Create an instance of HelloWorld.
    MainView mainv(applet, name, args);

    // Realize or show the buttonSample.
    mainv.realize();

    // Enter SOL++ event handling loop.
    applet.run();
}
