/**
@author d.Kingyo
@since 2006/04/08
@brief NYSLCPU擾DLL
@note
licence is NYSL
*/


#ifndef NYSL_CPU_H
#define NYSL_CPU_H

#ifdef NYSL_CPU_EXPORTS

#include <dkutil_c/dkutil_cstd/stdlib.h>
#define NYSL_CPU_DLL_PORT __declspec(dllexport)


typedef DKCSTD_CPU_INFO NYSL_CPU_CPU_INFO;

#else

#ifdef _MSC_VER
#pragma comment(lib,"nysl_cpu")
#endif

#define NYSL_CPU_DLL_PORT __declspec(dllimport)

typedef struct nyslcpu_CPU_INFO{
	char CPUName[256];
	char CPUType[128];
	unsigned char bFPU;
	unsigned char bTSC;
	unsigned char bCMOV;
	unsigned char bFCMOV;
	unsigned char bCPUID;
	unsigned char bMMX;
	unsigned char bMMX2;
	unsigned char bSSE;
	unsigned char bSSE2;
	unsigned char b3DNOW;
	unsigned char bE3DNOW;
	long TypeID;
	long FamilyID;
	long ModelID;
	long SteppingID;
	long CPUClock;
}NYSL_CPU_CPU_INFO;

#endif

#ifdef __cplusplus
#define NYSL_CPU_EXTERN_C extern "C"
#else
#define NYSL_CPU_EXTERN_C extern
#endif

#define NYSL_CPU_EXTERN NYSL_CPU_EXTERN_C NYSL_CPU_DLL_PORT 

#include <windows.h>



/**
@param dest[out] DKCSTD_CPU_INFO\̂CPȔi[
@param CPUClockCalcTime[in] CPŨNbN𑪒肷鎞 10(0.01b)炢x悢B0Ƒ肵ȂB
@return TRUEŐ
*/
///CPȔԂ擾B@note dkutil_cstd/x86.ĥƓ
NYSL_CPU_EXTERN int WINAPI nysl_cpuGetX86CPUInfo(NYSL_CPU_CPU_INFO *dest);

NYSL_CPU_EXTERN BOOL WINAPI nysl_cpuIsFPU();
NYSL_CPU_EXTERN BOOL WINAPI nysl_cpuIsTSC();
NYSL_CPU_EXTERN BOOL WINAPI nysl_cpuIsCMOV();
NYSL_CPU_EXTERN BOOL WINAPI nysl_cpuIsFCMOV();
NYSL_CPU_EXTERN BOOL WINAPI nysl_cpuIsCPUID();
NYSL_CPU_EXTERN BOOL WINAPI nysl_cpuIsMMX();
NYSL_CPU_EXTERN BOOL WINAPI nysl_cpuIsMMX2();
NYSL_CPU_EXTERN BOOL WINAPI nysl_cpuIsSSE();
NYSL_CPU_EXTERN BOOL WINAPI nysl_cpuIsSSE2();
NYSL_CPU_EXTERN BOOL WINAPI nysl_cpuIs3DNOW();
NYSL_CPU_EXTERN BOOL WINAPI nysl_cpuIsE3DNOW();

#endif