<?php
// $Id: date_time.inc,v 1.1.2.1 2007/03/26 17:30:20 z0rac Exp $

function _jbox_date_time_format(&$form) {
  static $formats = array(
    'short' => array(
      'Y年n月j日 H:i', 'Y年n月j日 g:ia', 'Y年n月j日 G時i分', 'Y年n月j日 g時i分a',
      'Y年m月d日 H:i', 'Y年m月d日 g:ia', 'Y年m月d日 G時i分', 'Y年m月d日 g時i分a',
      'Y-m-d H:i', 'Y-m-d g:ia', 'Y/m/d H:i', 'Y/m/d g:ia'
    ),
    'medium' => array(
      'Y年n月j日(D) H:i', 'Y年n月j日(D) g:ia', 'Y年n月j日(D) G時i分', 'Y年n月j日(D) g時i分a',
      'Y年m月d日(D) H:i', 'Y年m月d日(D) g:ia', 'Y年m月d日(D) G時i分', 'Y年m月d日(D) g時i分a',
      'Y-m-d(D) H:i', 'Y-m-d(D) g:ia', 'Y/m/d(D) H:i', 'Y/m/d(D) g:ia'
    ),
    'long' => array(
      'Y年n月j日(l) H:i', 'Y年n月j日(l) g:ia', 'Y年n月j日(l) G時i分', 'Y年n月j日(l) g時i分a',
      'Y年m月d日(l) H:i', 'Y年m月d日(l) g:ia', 'Y年m月d日(l) G時i分', 'Y年m月d日(l) g時i分a'
    )
  );
  $t = time();
  foreach ($formats as $type => $values) {
    $options = array();
    foreach ($values as $f) {
      $options[$f] = format_date($t, 'custom', $f);
    }
    $form['date_format_'. $type]['#options'] = array_merge(
      $options,
      $form['date_format_'. $type]['#options']
    );
  }
}
