<?php
// $Id: japanese.profile,v 1.1.2.2 2007/04/10 12:37:33 z0rac Exp $

/**
 * Return an array of the modules to be enabled when this profile is installed.
 *
 * @return
 *  An array of modules to be enabled.
 */
function japanese_profile_modules() {
  global $conf;
  $conf['update_locale_cvs'] = ':pserver:anonymous@cvs.sourceforge.jp:/cvsroot/drupal-jp';
  return array('block', 'color', 'comment', 'filter', 'help', 'locale', 'menu', 'node', 'system', 'taxonomy', 'user', 'watchdog', 'jbox', 'update_locale');
}

/**
 * Return a description of the profile.
 */
function japanese_profile_details() {
  return array(
    'name' => '日本語Drupal',
    'description' => '日本語に翻訳されたDrupalをインストールする場合は、このプロフィールを選択してください。'
  );
}

/**
 * Implementation of hook_profile_final().
 */
function japanese_profile_final() {
  variable_set('update_locale_cvs', ':pserver:anonymous@cvs.sourceforge.jp:/cvsroot/drupal-jp');

  // Insert default user-defined node types into the database.
  $types = array(
    array(
      'type' => 'page',
      'name' => st('Page'),
      'module' => 'node',
      'description' => st('If you want to add a static page, like a contact page or an about page, use a page.'),
      'custom' => TRUE,
      'modified' => TRUE,
      'locked' => FALSE,
    ),
    array(
      'type' => 'story',
      'name' => st('Story'),
      'module' => 'node',
      'description' => st('Stories are articles in their simplest form: they have a title, a teaser and a body, but can be extended by other modules. The teaser is part of the body too. Stories may be used as a personal blog or for news articles.'),
      'custom' => TRUE,
      'modified' => TRUE,
      'locked' => FALSE,
    ),
  );

  foreach ($types as $type) {
    $type = (object) _node_type_set_defaults($type);
    node_type_save($type);
  }

  // Default page to not be promoted and have comments disabled.
  variable_set('node_options_page', array('status'));
  variable_set('comment_page', COMMENT_NODE_DISABLED);

  // Don't display date and author information for page nodes by default.
  $theme_settings = variable_get('theme_settings', array());
  $theme_settings['toggle_node_info_page'] = FALSE;
  variable_set('theme_settings', $theme_settings);
}
